/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.updater.DeploymentProperties;

public class DeploymentData {
    private final DeploymentProperties deploymentProps;
    private final Set<File> zipFiles;
    private final Map<File, File> rawFiles;
    private final File destinationDir;
    private final File sourceDir;
    private final Map<File, Pattern> zipEntriesToRealizeRegex;
    private final Set<File> rawFilesToRealize;
    private final TemplateEngine templateEngine;
    private final Pattern ignoreRegex;
    private final boolean manageRootDir;
    private final Map<File, Boolean> zipsExploded;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeploymentData(DeploymentProperties deploymentProps, Set<File> zipFiles, Map<File, File> rawFiles, File sourceDir, File destinationDir, Map<File, Pattern> zipEntriesToRealizeRegex, Set<File> rawFilesToRealize, TemplateEngine templateEngine, Pattern ignoreRegex, boolean manageRootDir, Map<File, Boolean> zipsExploded) {
        if (deploymentProps == null) {
            throw new IllegalArgumentException("deploymentProps == null");
        }
        if (destinationDir == null) {
            throw new IllegalArgumentException("destinationDir == null");
        }
        if (sourceDir == null) {
            throw new IllegalArgumentException("sourceDir == null");
        }
        if (zipFiles == null) {
            zipFiles = new HashSet<File>(0);
        }
        if (rawFiles == null) {
            rawFiles = new HashMap<File, File>(0);
        }
        if (zipFiles.size() == 0 && rawFiles.size() == 0) {
            throw new IllegalArgumentException("zipFiles/rawFiles are empty - nothing to do");
        }
        if (zipsExploded == null) {
            zipsExploded = new HashMap<File, Boolean>(0);
        }
        this.deploymentProps = deploymentProps;
        this.zipFiles = zipFiles;
        this.rawFiles = rawFiles;
        this.destinationDir = this.getCanonicalFile(destinationDir);
        this.sourceDir = sourceDir;
        this.ignoreRegex = ignoreRegex;
        this.manageRootDir = manageRootDir;
        this.zipsExploded = zipsExploded;
        if (templateEngine == null || zipEntriesToRealizeRegex == null && rawFilesToRealize == null) {
            this.zipEntriesToRealizeRegex = null;
            this.rawFilesToRealize = null;
            this.templateEngine = null;
        } else {
            this.zipEntriesToRealizeRegex = zipEntriesToRealizeRegex;
            this.rawFilesToRealize = rawFilesToRealize;
            this.templateEngine = templateEngine;
        }
        for (Map.Entry<File, File> entry : this.rawFiles.entrySet()) {
            File fileToCanonicalize;
            File rawFile = entry.getValue();
            String rawFilePath = rawFile.getPath();
            boolean doubledot = rawFilePath.replace('\\', '/').matches(".*((/\\.\\.)|(\\.\\./)).*");
            if (!doubledot) continue;
            if (rawFile.isAbsolute()) {
                fileToCanonicalize = rawFile;
            } else {
                boolean isWindows;
                boolean bl = isWindows = File.separatorChar == '\\';
                if (isWindows) {
                    StringBuilder rawFilePathBuilder = new StringBuilder(rawFilePath);
                    String rawFileDriveLetter = FileUtil.stripDriveLetter(rawFilePathBuilder);
                    StringBuilder destDirAbsPathBuilder = new StringBuilder(this.destinationDir.getAbsolutePath());
                    String destDirDriveLetter = FileUtil.stripDriveLetter(destDirAbsPathBuilder);
                    if (destDirDriveLetter != null && rawFileDriveLetter != null && !rawFileDriveLetter.equals(destDirDriveLetter)) throw new IllegalArgumentException("Cannot normalize relative path [" + rawFilePath + "]; its drive letter is different than the destination directory [" + this.destinationDir.getAbsolutePath() + "]");
                    fileToCanonicalize = new File(this.destinationDir, rawFilePathBuilder.toString());
                } else {
                    fileToCanonicalize = new File(this.destinationDir, rawFilePath);
                }
            }
            fileToCanonicalize = this.getCanonicalFile(fileToCanonicalize);
            if (this.isPathUnderBaseDir(this.destinationDir, fileToCanonicalize)) {
                String baseDir = this.destinationDir.getAbsolutePath();
                String absRawFilePath = fileToCanonicalize.getAbsolutePath();
                String canonicalRelativePath = absRawFilePath.substring(baseDir.length() + 1);
                entry.setValue(new File(canonicalRelativePath));
                continue;
            }
            entry.setValue(fileToCanonicalize);
        }
    }

    public DeploymentProperties getDeploymentProps() {
        return this.deploymentProps;
    }

    public Set<File> getZipFiles() {
        return this.zipFiles;
    }

    public Map<File, File> getRawFiles() {
        return this.rawFiles;
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public Map<File, Pattern> getZipEntriesToRealizeRegex() {
        return this.zipEntriesToRealizeRegex;
    }

    public Set<File> getRawFilesToRealize() {
        return this.rawFilesToRealize;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public Pattern getIgnoreRegex() {
        return this.ignoreRegex;
    }

    public boolean isManageRootDir() {
        return this.manageRootDir;
    }

    public Map<File, Boolean> getZipsExploded() {
        return this.zipsExploded;
    }

    private File getCanonicalFile(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (Exception e) {
            file = file.getAbsoluteFile();
        }
        return file;
    }

    private boolean isPathUnderBaseDir(File base, File path) {
        if (base == null) {
            return false;
        }
        while (path != null) {
            if (base.equals(path)) {
                return true;
            }
            path = path.getParentFile();
        }
        return false;
    }
}

