/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.exception.ValidationErrors;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.PrimaryKeyConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddColumnChange
extends AbstractChange
implements ChangeWithColumns<ColumnConfig> {
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public AddColumnChange() {
        super("addColumn", "Add Column", 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public void removeColumn(ColumnConfig column) {
        this.columns.remove(column);
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = super.validate(database);
        if (this.columns.size() == 0) {
            validationErrors.addError("'columns' is required");
        }
        return validationErrors;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        ArrayList<AbstractSqlStatement> sql = new ArrayList<AbstractSqlStatement>();
        for (ColumnConfig aColumn : this.getColumns()) {
            HashSet<ColumnConstraint> constraints = new HashSet<ColumnConstraint>();
            if (aColumn.getConstraints() != null) {
                if (aColumn.getConstraints().isNullable() != null && !aColumn.getConstraints().isNullable().booleanValue()) {
                    constraints.add(new NotNullConstraint());
                }
                if (aColumn.getConstraints().isUnique() != null && aColumn.getConstraints().isUnique().booleanValue()) {
                    constraints.add(new UniqueConstraint());
                }
                if (aColumn.getConstraints().isPrimaryKey() != null && aColumn.getConstraints().isPrimaryKey().booleanValue()) {
                    constraints.add(new PrimaryKeyConstraint(aColumn.getConstraints().getPrimaryKeyName()));
                }
                if (aColumn.getConstraints().getReferences() != null) {
                    constraints.add(new ForeignKeyConstraint(aColumn.getConstraints().getForeignKeyName(), aColumn.getConstraints().getReferences()));
                }
            }
            if (aColumn.isAutoIncrement() != null && aColumn.isAutoIncrement().booleanValue()) {
                constraints.add(new AutoIncrementConstraint(aColumn.getName(), aColumn.getStartWith(), aColumn.getIncrementBy()));
            }
            AddColumnStatement addColumnStatement = new AddColumnStatement(this.getSchemaName(), this.getTableName(), aColumn.getName(), aColumn.getType(), aColumn.getDefaultValueObject(), constraints.toArray(new ColumnConstraint[constraints.size()]));
            sql.add(addColumnStatement);
            if (database instanceof DB2Database) {
                sql.add(new ReorganizeTableStatement(this.getSchemaName(), this.getTableName()));
            }
            if (aColumn.getValueObject() == null) continue;
            UpdateStatement updateStatement = new UpdateStatement(this.getSchemaName(), this.getTableName());
            updateStatement.addNewColumnValue(aColumn.getName(), aColumn.getValueObject());
            sql.add(updateStatement);
        }
        return sql.toArray(new SqlStatement[sql.size()]);
    }

    @Override
    protected Change[] createInverses() {
        ArrayList<AbstractChange> inverses = new ArrayList<AbstractChange>();
        for (ColumnConfig aColumn : this.columns) {
            if (aColumn.hasDefaultValue()) {
                DropDefaultValueChange dropChange = new DropDefaultValueChange();
                dropChange.setTableName(this.getTableName());
                dropChange.setColumnName(aColumn.getName());
                inverses.add(dropChange);
            }
            DropColumnChange inverse = new DropColumnChange();
            inverse.setSchemaName(this.getSchemaName());
            inverse.setColumnName(aColumn.getName());
            inverse.setTableName(this.getTableName());
            inverses.add(inverse);
        }
        return inverses.toArray(new Change[inverses.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        ArrayList<String> names = new ArrayList<String>(this.columns.size());
        for (ColumnConfig col : this.columns) {
            names.add(col.getName() + "(" + col.getType() + ")");
        }
        return "Columns " + StringUtils.join(names, ",") + " added to " + this.tableName;
    }
}

