/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.event.log.LogEntryProcessor;
import org.rhq.core.pluginapi.event.log.LogFileEventPoller;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.apache.ApacheErrorLogEntryProcessor;
import org.rhq.plugins.apache.ApacheServerOperationsDelegate;
import org.rhq.plugins.apache.util.ApacheBinaryInfo;
import org.rhq.plugins.www.snmp.SNMPClient;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPValue;
import org.rhq.plugins.www.util.WWWUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheServerComponent
implements ResourceComponent,
MeasurementFacet,
OperationFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String PLUGIN_CONFIG_PROP_SERVER_ROOT = "serverRoot";
    public static final String PLUGIN_CONFIG_PROP_EXECUTABLE_PATH = "executablePath";
    public static final String PLUGIN_CONFIG_PROP_CONTROL_SCRIPT_PATH = "controlScriptPath";
    public static final String PLUGIN_CONFIG_PROP_URL = "url";
    public static final String PLUGIN_CONFIG_PROP_HTTPD_CONF = "configFile";
    public static final String PLUGIN_CONFIG_PROP_SNMP_AGENT_HOST = "snmpAgentHost";
    public static final String PLUGIN_CONFIG_PROP_SNMP_AGENT_PORT = "snmpAgentPort";
    public static final String PLUGIN_CONFIG_PROP_SNMP_AGENT_COMMUNITY = "snmpAgentCommunity";
    public static final String PLUGIN_CONFIG_PROP_ERROR_LOG_FILE_PATH = "errorLogFilePath";
    public static final String PLUGIN_CONFIG_PROP_ERROR_LOG_EVENTS_ENABLED = "errorLogEventsEnabled";
    public static final String PLUGIN_CONFIG_PROP_ERROR_LOG_MINIMUM_SEVERITY = "errorLogMinimumSeverity";
    public static final String PLUGIN_CONFIG_PROP_ERROR_LOG_INCLUDES_PATTERN = "errorLogIncludesPattern";
    public static final String SERVER_BUILT_TRAIT = "serverBuilt";
    public static final String DEFAULT_EXECUTABLE_PATH = "bin" + File.separator + (File.separatorChar == '/' ? "httpd" : "Apache.exe");
    public static final String DEFAULT_ERROR_LOG_PATH = "logs" + File.separator + (File.separatorChar == '/' ? "error_log" : "error.log");
    private static final String ERROR_LOG_ENTRY_EVENT_TYPE = "errorLogEntry";
    private static final String[] CONTROL_SCRIPT_PATHS = new String[]{"bin/apachectl", "sbin/apachectl", "bin/apachectl2", "sbin/apachectl2"};
    private ResourceContext resourceContext;
    private EventContext eventContext;
    private SNMPClient snmpClient;
    private URL url;
    private ApacheBinaryInfo binaryInfo;
    private long availPingTime = -1L;
    private ApacheServerOperationsDelegate operationsDelegate;

    public void start(ResourceContext resourceContext) throws Exception {
        this.log.info((Object)("Initializing server component for server [" + resourceContext.getResourceKey() + "]..."));
        this.resourceContext = resourceContext;
        this.eventContext = resourceContext.getEventContext();
        this.snmpClient = new SNMPClient();
        try {
            boolean configured = false;
            SNMPSession snmpSession = this.getSNMPSession();
            if (!snmpSession.ping()) {
                this.log.warn((Object)("Failed to connect to SNMP agent at " + snmpSession + "\n" + ". Make sure\n1) the managed Apache server has been instrumented with the JON SNMP module,\n" + "2) the Apache server is running, and\n" + "3) the SNMP agent host, port, and community are set correctly in this resource's connection properties.\n" + "The agent will not be able to record metrics from apache httpd without SNMP"));
            } else {
                configured = true;
            }
            Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
            String url = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_URL, null);
            if (url != null) {
                try {
                    this.url = new URL(url);
                    if (this.url.getPort() == 0) {
                        this.log.error((Object)"The 'url' connection property is invalid - 0 is not a valid port; please change the value to the port the \"main\" Apache server is listening on. NOTE: If the 'url' property was set this way after autodiscovery, you most likely did not include the port in the ServerName directive for the \"main\" Apache server in httpd.conf.");
                    } else {
                        configured = true;
                    }
                }
                catch (MalformedURLException e) {
                    throw new InvalidPluginConfigurationException("Value of 'url' connection property ('" + url + "') is not a valid URL.");
                }
            }
            if (!configured) {
                throw new InvalidPluginConfigurationException("Neither SNMP nor an URL for checking availability has been configured");
            }
            File executablePath = this.getExecutablePath();
            try {
                this.binaryInfo = ApacheBinaryInfo.getInfo(executablePath.getPath(), this.resourceContext.getSystemInformation());
            }
            catch (Exception e) {
                throw new InvalidPluginConfigurationException("'" + executablePath + "' is not a valid Apache executable (" + e + ").");
            }
            this.operationsDelegate = new ApacheServerOperationsDelegate(this, this.resourceContext.getSystemInformation());
            this.startEventPollers();
        }
        catch (Exception e) {
            if (this.snmpClient != null) {
                this.snmpClient.close();
            }
            throw e;
        }
    }

    public void stop() {
        this.stopEventPollers();
        if (this.snmpClient != null) {
            this.snmpClient.close();
        }
    }

    public AvailabilityType getAvailability() {
        boolean available;
        try {
            if (this.url != null) {
                long t1 = System.currentTimeMillis();
                available = WWWUtils.isAvailable(this.url);
                this.availPingTime = System.currentTimeMillis() - t1;
            } else {
                available = this.getSNMPSession().ping();
                this.availPingTime = -1L;
            }
        }
        catch (Exception e) {
            available = false;
        }
        return available ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> schedules) throws Exception {
        SNMPSession snmpSession = this.getSNMPSession();
        boolean snmpPresent = snmpSession.ping();
        for (MeasurementScheduleRequest schedule : schedules) {
            String metricName = schedule.getName();
            if (metricName.equals(SERVER_BUILT_TRAIT)) {
                MeasurementDataTrait trait = new MeasurementDataTrait(schedule, this.binaryInfo.getBuilt());
                report.addData(trait);
                continue;
            }
            if (metricName.equals("rhq_avail_ping_time")) {
                if (this.availPingTime == -1L) continue;
                MeasurementDataNumeric num = new MeasurementDataNumeric(schedule, Double.valueOf(this.availPingTime));
                report.addData(num);
                continue;
            }
            if (!snmpPresent) continue;
            try {
                String mibName = metricName;
                List<SNMPValue> snmpValues = snmpSession.getColumn(mibName);
                if (snmpValues.isEmpty()) {
                    this.log.error((Object)("No values found for MIB name [" + mibName + "]."));
                    continue;
                }
                SNMPValue snmpValue = snmpValues.get(0);
                boolean valueIsTimestamp = this.isValueTimestamp(mibName);
                this.log.debug((Object)("Collected SNMP metric [" + mibName + "], value = " + snmpValue));
                ApacheServerComponent.addSnmpMetricValueToReport(report, schedule, snmpValue, valueIsTimestamp);
            }
            catch (SNMPException e) {
                this.log.error((Object)"An error occurred while attempting to collect an SNMP metric.", (Throwable)e);
            }
        }
    }

    private boolean isValueTimestamp(String mibName) {
        return mibName.equals("wwwServiceStartTime");
    }

    public void startOperationFacet(OperationContext context) {
    }

    @Nullable
    public OperationResult invokeOperation(@NotNull String name, @NotNull Configuration params) throws Exception {
        this.log.info((Object)("Invoking operation [" + name + "] on server [" + this.resourceContext.getResourceKey() + "]..."));
        return this.operationsDelegate.invokeOperation(name, params);
    }

    @NotNull
    public SNMPSession getSNMPSession() throws Exception {
        return ApacheServerComponent.getSNMPSession(this.snmpClient, this.resourceContext.getPluginConfiguration());
    }

    @NotNull
    public static SNMPSession getSNMPSession(SNMPClient snmpClient, Configuration pluginConfig) throws Exception {
        SNMPSession snmpSession;
        try {
            String host = pluginConfig.getSimple(PLUGIN_CONFIG_PROP_SNMP_AGENT_HOST).getStringValue();
            String portString = pluginConfig.getSimple(PLUGIN_CONFIG_PROP_SNMP_AGENT_PORT).getStringValue();
            int port = Integer.valueOf(portString);
            String community = pluginConfig.getSimple(PLUGIN_CONFIG_PROP_SNMP_AGENT_COMMUNITY).getStringValue();
            snmpSession = snmpClient.getSession(host, port, community, SNMPClient.SNMPVersion.V2C);
        }
        catch (SNMPException e) {
            throw new Exception("Error getting SNMP session: " + e.getMessage(), e);
        }
        return snmpSession;
    }

    @NotNull
    public File getServerRoot() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String serverRoot = ApacheServerComponent.getRequiredPropertyValue(pluginConfig, PLUGIN_CONFIG_PROP_SERVER_ROOT);
        return new File(serverRoot);
    }

    @NotNull
    public File getExecutablePath() {
        File executableFile;
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String executablePath = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_EXECUTABLE_PATH, null);
        if (executablePath != null) {
            executableFile = this.resolvePathRelativeToServerRoot(executablePath);
        } else {
            String serverRoot = ApacheServerComponent.getRequiredPropertyValue(pluginConfig, PLUGIN_CONFIG_PROP_SERVER_ROOT);
            SystemInfo systemInfo = this.resourceContext.getSystemInformation();
            if (systemInfo.getOperatingSystemType() != OperatingSystemType.WINDOWS) {
                executableFile = new File(serverRoot, "bin/httpd");
                if (!executableFile.exists()) {
                    executableFile = new File(serverRoot, "bin/apache2");
                }
                if (!executableFile.exists()) {
                    executableFile = new File(serverRoot, "bin/apache");
                }
            } else {
                executableFile = new File(serverRoot, "bin/Apache.exe");
            }
        }
        return executableFile;
    }

    public File getHttpdConfFile() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        PropertySimple prop = pluginConfig.getSimple(PLUGIN_CONFIG_PROP_HTTPD_CONF);
        if (prop == null || prop.getStringValue() == null) {
            return null;
        }
        return ApacheServerComponent.resolvePathRelativeToServerRoot(pluginConfig, prop.getStringValue());
    }

    @NotNull
    public File getControlScriptPath() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String controlScriptPath = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_CONTROL_SCRIPT_PATH, null);
        File controlScriptFile = null;
        if (controlScriptPath != null) {
            controlScriptFile = this.resolvePathRelativeToServerRoot(controlScriptPath);
        } else {
            SystemInfo systemInfo = this.resourceContext.getSystemInformation();
            if (systemInfo.getOperatingSystemType() != OperatingSystemType.WINDOWS) {
                String executablePath;
                boolean found = false;
                String serverRoot = ApacheServerComponent.getRequiredPropertyValue(pluginConfig, PLUGIN_CONFIG_PROP_SERVER_ROOT);
                for (String path : CONTROL_SCRIPT_PATHS) {
                    controlScriptFile = new File(serverRoot, path);
                    if (!controlScriptFile.exists()) continue;
                    found = true;
                    break;
                }
                if (!found && (executablePath = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_EXECUTABLE_PATH, null)) != null) {
                    int i = executablePath.lastIndexOf(47);
                    executablePath = executablePath.substring(0, i);
                    i = executablePath.lastIndexOf(47);
                    executablePath = executablePath.substring(0, i);
                    for (String path : CONTROL_SCRIPT_PATHS) {
                        controlScriptFile = new File(executablePath, path);
                        if (!controlScriptFile.exists()) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    controlScriptFile = this.getExecutablePath();
                }
            } else {
                controlScriptFile = this.getExecutablePath();
            }
        }
        return controlScriptFile;
    }

    static void addSnmpMetricValueToReport(MeasurementReport report, MeasurementScheduleRequest schedule, SNMPValue snmpValue, boolean valueIsTimestamp) throws SNMPException {
        switch (schedule.getDataType()) {
            case MEASUREMENT: {
                MeasurementDataNumeric metric = new MeasurementDataNumeric(schedule, Double.valueOf(snmpValue.toLong()));
                report.addData(metric);
                break;
            }
            case TRAIT: {
                String stringValue;
                if (valueIsTimestamp) {
                    stringValue = new Date(snmpValue.toLong()).toString();
                } else {
                    stringValue = snmpValue.toString();
                    if (stringValue.startsWith("1.3.6.1.2.1.6.")) {
                        stringValue = stringValue.substring(stringValue.lastIndexOf(46) + 1);
                    }
                }
                MeasurementDataTrait trait = new MeasurementDataTrait(schedule, stringValue);
                report.addData(trait);
                break;
            }
            default: {
                throw new IllegalStateException("SNMP metric request has unsupported data type: " + schedule.getDataType());
            }
        }
    }

    @NotNull
    private File resolvePathRelativeToServerRoot(@NotNull String path) {
        return ApacheServerComponent.resolvePathRelativeToServerRoot(this.resourceContext.getPluginConfiguration(), path);
    }

    @NotNull
    static File resolvePathRelativeToServerRoot(Configuration pluginConfig, @NotNull String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            String serverRoot = ApacheServerComponent.getRequiredPropertyValue(pluginConfig, PLUGIN_CONFIG_PROP_SERVER_ROOT);
            file = new File(serverRoot, path);
        }
        return file;
    }

    @NotNull
    static String getRequiredPropertyValue(@NotNull Configuration config, @NotNull String propName) {
        String propValue = config.getSimpleValue(propName, null);
        if (propValue == null) {
            throw new IllegalStateException("Required property '" + propName + "' is not set.");
        }
        return propValue;
    }

    private void startEventPollers() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        Boolean enabled = Boolean.valueOf(pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_ERROR_LOG_EVENTS_ENABLED, null));
        if (enabled.booleanValue()) {
            String minimumSeverityString;
            File errorLogFile = this.resolvePathRelativeToServerRoot(pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_ERROR_LOG_FILE_PATH, DEFAULT_ERROR_LOG_PATH));
            ApacheErrorLogEntryProcessor processor = new ApacheErrorLogEntryProcessor(ERROR_LOG_ENTRY_EVENT_TYPE, errorLogFile);
            String includesPatternString = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_ERROR_LOG_INCLUDES_PATTERN, null);
            if (includesPatternString != null) {
                try {
                    Pattern includesPattern = Pattern.compile(includesPatternString);
                    processor.setIncludesPattern(includesPattern);
                }
                catch (PatternSyntaxException e) {
                    throw new InvalidPluginConfigurationException("Includes pattern [" + includesPatternString + "] is not a valid regular expression.");
                }
            }
            if ((minimumSeverityString = pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_ERROR_LOG_MINIMUM_SEVERITY, null)) != null) {
                EventSeverity minimumSeverity = EventSeverity.valueOf((String)minimumSeverityString.toUpperCase());
                processor.setMinimumSeverity(minimumSeverity);
            }
            LogFileEventPoller poller = new LogFileEventPoller(this.eventContext, ERROR_LOG_ENTRY_EVENT_TYPE, errorLogFile, (LogEntryProcessor)processor);
            this.eventContext.registerEventPoller((EventPoller)poller, 60, errorLogFile.getPath());
        }
    }

    private void stopEventPollers() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        File errorLogFile = this.resolvePathRelativeToServerRoot(pluginConfig.getSimpleValue(PLUGIN_CONFIG_PROP_ERROR_LOG_FILE_PATH, DEFAULT_ERROR_LOG_PATH));
        this.eventContext.unregisterEventPoller(ERROR_LOG_ENTRY_EVENT_TYPE, errorLogFile.getPath());
    }
}

