/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HttpdAddressUtility {
    APACHE_1_3{

        public Address getMainServerSampleAddress(ApacheDirectiveTree ag, String limitToHost, int limitToPort) {
            try {
                List<String> values;
                List<ApacheDirective> ports = ag.search("/Port");
                List<ApacheDirective> bindAddresses = ag.search("/BindAddress");
                List<ApacheDirective> listens = ag.search("/Listen");
                String port = "80";
                String bindAddress = null;
                ArrayList<Address> addressesToMatch = new ArrayList<Address>();
                if (ports.size() > 0 && (values = ports.get(0).getValues()).size() > 0) {
                    port = values.get(0);
                }
                if (bindAddresses.size() > 0 && (values = bindAddresses.get(0).getValues()).size() > 0) {
                    bindAddress = values.get(0);
                }
                if (listens.size() > 0) {
                    for (ApacheDirective l : listens) {
                        addressesToMatch.add(HttpdAddressUtility.parseListen(l.getValues().get(0)));
                    }
                } else {
                    addressesToMatch.add(new Address(bindAddress, Integer.parseInt(port)));
                }
                for (Address address : addressesToMatch) {
                    if (!1.isAddressConforming(address, limitToHost, limitToPort, false)) continue;
                    if (!address.isPortDefined() || address.isPortWildcard()) {
                        address.port = 80;
                    }
                    if (address.host == null || address.isHostDefault() || address.isHostWildcard()) {
                        address = HttpdAddressUtility.getLocalhost(address.port);
                    }
                    HttpdAddressUtility.updateWithServerName(address, ag);
                    return address;
                }
                return null;
            }
            catch (Exception e) {
                log.info((Object)"Failed to obtain main server address. Is augeas installed and correct lens in use?");
                return null;
            }
        }
    }
    ,
    APACHE_2_x{

        public Address getMainServerSampleAddress(ApacheDirectiveTree ag, String limitToHost, int limitToPort) {
            try {
                for (ApacheDirective n : ag.search("/Listen")) {
                    Address addr = HttpdAddressUtility.parseListen(n.getValues().get(0));
                    if (!2.isAddressConforming(addr, limitToHost, limitToPort, false)) continue;
                    if (addr.host == null || addr.isHostDefault() || addr.isHostWildcard()) {
                        addr = HttpdAddressUtility.getLocalhost(addr.port);
                    }
                    HttpdAddressUtility.updateWithServerName(addr, ag);
                    return addr;
                }
                throw new IllegalStateException("Could find a listen address on port " + limitToPort);
            }
            catch (Exception e) {
                log.info((Object)"Failed to obtain main server address. Is augeas installed and correct lens in use?");
                return null;
            }
        }
    };

    private static final Log log;

    public static HttpdAddressUtility get(String version) {
        return version.startsWith("1.") ? APACHE_1_3 : APACHE_2_x;
    }

    public abstract Address getMainServerSampleAddress(ApacheDirectiveTree var1, String var2, int var3);

    public Address getVirtualHostSampleAddress(ApacheDirectiveTree ag, String virtualHost, String serverName, boolean snmpModuleCompatibleMode) {
        Address addr = Address.parse(virtualHost);
        if (addr.isHostDefault() || addr.isHostWildcard()) {
            Address serverAddr = null;
            serverAddr = snmpModuleCompatibleMode ? HttpdAddressUtility.getLocalhost(addr.port) : this.getMainServerSampleAddress(ag, null, addr.port);
            if (serverAddr == null) {
                return null;
            }
            addr.host = serverAddr.host;
        }
        if (serverName != null) {
            int colonIdx = serverName.indexOf(58);
            if (colonIdx >= 0) {
                addr.host = serverName.substring(0, colonIdx);
                addr.port = Integer.parseInt(serverName.substring(colonIdx + 1));
            } else {
                addr.host = serverName;
            }
        }
        return addr;
    }

    private static Address parseListen(String listenValue) {
        Address ret = Address.parse(listenValue);
        if (!ret.isPortDefined()) {
            try {
                ret.port = Integer.parseInt(ret.host);
            }
            catch (NumberFormatException e) {
                return null;
            }
            ret.host = null;
        }
        return ret;
    }

    public static boolean isAddressConforming(Address listen, String limitingHost, int limitingPort, boolean snmpModuleCompatibleMode) {
        boolean portOk;
        if ("_default_".equals(limitingHost) || "*".equals(limitingHost)) {
            limitingHost = null;
        }
        boolean hostOk = limitingHost == null;
        boolean bl = portOk = limitingPort <= 0;
        if (!hostOk && (listen.host == null || limitingHost.equals(listen.host))) {
            hostOk = true;
        }
        int listenPort = listen.port;
        if (snmpModuleCompatibleMode) {
            if (limitingPort == 80) {
                limitingPort = 0;
            }
            if (listenPort == 80) {
                listenPort = 0;
            }
        }
        if (!portOk && limitingPort == listenPort) {
            portOk = true;
        }
        return hostOk && portOk;
    }

    private static Address getLocalhost(int port) {
        try {
            return new Address(InetAddress.getLocalHost().getHostAddress(), port);
        }
        catch (UnknownHostException e) {
            return new Address("127.0.0.1", port);
        }
    }

    private static void updateWithServerName(Address address, ApacheDirectiveTree config) throws UnknownHostException {
        List<ApacheDirective> serverNameNodes = config.search("/ServerName");
        if (serverNameNodes.size() > 0) {
            String serverName = serverNameNodes.get(0).getValuesAsString();
            InetAddress addrFromServerName = InetAddress.getByName(serverName);
            InetAddress addrFromAddress = InetAddress.getByName(address.host);
            if (addrFromAddress.equals(addrFromServerName)) {
                address.host = serverName;
            }
        }
    }

    static {
        log = LogFactory.getLog(HttpdAddressUtility.class);
    }

    public static class Address {
        public String host;
        public int port = -1;
        public static final String WILDCARD = "*";
        public static final String DEFAULT_HOST = "_default_";
        public static final int PORT_WILDCARD_VALUE = 0;
        public static final int NO_PORT_SPECIFIED_VALUE = -1;

        public Address(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public static Address parse(String address) {
            int lastColonIdx = address.lastIndexOf(58);
            if (lastColonIdx == -1) {
                return new Address(address, -1);
            }
            int lastRightBracketPos = address.lastIndexOf(93);
            if (lastColonIdx > lastRightBracketPos) {
                String host = address.substring(0, lastColonIdx);
                String portSpec = address.substring(lastColonIdx + 1);
                int port = -1;
                port = WILDCARD.equals(portSpec) ? 0 : Integer.parseInt(portSpec);
                return new Address(host, port);
            }
            return new Address(address, -1);
        }

        public boolean isPortWildcard() {
            return this.port == 0;
        }

        public boolean isPortDefined() {
            return this.port != -1;
        }

        public boolean isHostWildcard() {
            return WILDCARD.equals(this.host);
        }

        public boolean isHostDefault() {
            return DEFAULT_HOST.equals(this.host);
        }

        public int hashCode() {
            int hash = this.port;
            if (this.host != null) {
                hash *= this.host.hashCode();
            }
            return hash;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Address)) {
                return false;
            }
            Address o = (Address)other;
            if (this.host == null) {
                return o.host == null && this.port == o.port;
            }
            return this.host.equals(o.host) && this.port == o.port;
        }

        public String toString() {
            if (this.port == -1) {
                return this.host;
            }
            String portSpec = this.port == 0 ? WILDCARD : String.valueOf(this.port);
            return this.host + ":" + portSpec;
        }
    }
}

