/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.util.HttpdConfParser;
import org.rhq.plugins.www.util.WWWUtils;

public class ModJKDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheServerComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        HttpdConfParser parser;
        PropertySimple confPathProp;
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>(1);
        Configuration parentConfig = context.getParentResourceContext().getPluginConfiguration();
        PropertySimple urlString = parentConfig.getSimple("url");
        String modJkVersion = null;
        if (urlString != null) {
            try {
                URL url = new URL(urlString.getStringValue());
                String header = WWWUtils.getServerHeader(url);
                if (header != null && header.contains("mod_jk")) {
                    int blankPos = (header = header.substring(header.indexOf("mod_jk") + 7)).indexOf(" ");
                    modJkVersion = blankPos > 0 ? header.substring(0, header.indexOf(" ")) : header;
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if ((confPathProp = parentConfig.getSimple("configFile")) == null || confPathProp.getStringValue() == null) {
            this.log.error((Object)"Path to httpd.conf is not given - can't discover mod_jk");
            return null;
        }
        String confPath = confPathProp.getStringValue();
        if (!confPath.startsWith("/")) {
            String basePath = ((ApacheServerComponent)context.getParentResourceComponent()).getServerRoot().getAbsolutePath();
            confPath = basePath + "/" + confPath;
        }
        if ((parser = new HttpdConfParser()).parse(confPath) && parser.isModJkInstalled()) {
            PropertySimple workers;
            Configuration config = context.getDefaultPluginConfiguration();
            if (parser.getWorkerPropertiesFile() != null) {
                workers = new PropertySimple("workerFile", (Object)parser.getWorkerPropertiesFile());
                config.put((Property)workers);
            }
            if (parser.getUriWorkerLocation() != null) {
                workers = new PropertySimple("uriWorkerFile", (Object)parser.getUriWorkerLocation());
                config.put((Property)workers);
            }
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), confPath, "mod_jk", modJkVersion, "Mod_JK", config, null);
            details.add(detail);
            return details;
        }
        return null;
    }
}

