/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apt;

import java.io.File;
import java.util.Date;
import java.util.List;
import net.augeas.Augeas;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;

public class AptSourcesComponent
implements ResourceComponent,
ConfigurationFacet {
    private ResourceContext resourceContext;
    private File aptSourcesFile;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        Configuration pluginConfiguration = resourceContext.getPluginConfiguration();
        PropertySimple aptSourcesPathProperty = pluginConfiguration.getSimple("apt-sources-path");
        if (aptSourcesPathProperty == null) {
            throw new InvalidPluginConfigurationException("Apt sources not found in the plugin configuration, cannot start resource component");
        }
        String aptSourcesPath = aptSourcesPathProperty.getStringValue();
        this.aptSourcesFile = new File(aptSourcesPath);
        if (!this.aptSourcesFile.exists()) {
            throw new InvalidPluginConfigurationException("Apt sources file not found at specified location: " + aptSourcesPath);
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        if (this.aptSourcesFile == null) {
            return AvailabilityType.DOWN;
        }
        return this.aptSourcesFile.exists() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        return this.loadResourceConfiguration(pluginConfiguration);
    }

    public Configuration loadResourceConfiguration(Configuration pluginConfiguration) throws Exception {
        PropertySimple lensesPathProperty = pluginConfiguration.getSimple("lenses-path");
        if (lensesPathProperty == null) {
            throw new Exception("Lenses path not found in plugin configuration, cannot retrieve configuration");
        }
        PropertySimple rootPathProperty = pluginConfiguration.getSimple("root-path");
        if (rootPathProperty == null) {
            throw new Exception("Root path not found in plugin configuration, cannot retrieve configuration");
        }
        String lensesPath = lensesPathProperty.getStringValue();
        String rootPath = rootPathProperty.getStringValue();
        Augeas augeas = new Augeas(rootPath, lensesPath);
        PropertySimple augeasTreeNodeProperty = pluginConfiguration.getSimple("augeas-apt-sources-path");
        if (augeasTreeNodeProperty == null) {
            throw new Exception("Augeas tree node not specified for apt sources, cannot retrive configuration");
        }
        String sourcesTreeNode = augeasTreeNodeProperty.getStringValue();
        List matches = augeas.match(sourcesTreeNode);
        if (matches.size() == 0) {
            throw new Exception("Unable to load apt sources data from augeas");
        }
        Configuration configuration = new Configuration();
        configuration.setNotes("Loaded from Augeas at " + new Date());
        PropertyList entriesList = new PropertyList("aptEntries");
        configuration.put((Property)entriesList);
        for (String entryNode : matches) {
            String type = augeas.get(entryNode + "/type");
            String uri = augeas.get(entryNode + "/uri");
            String distribution = augeas.get(entryNode + "/distribution");
            PropertyMap entry = new PropertyMap("aptEntry");
            entry.put((Property)new PropertySimple("type", (Object)type));
            entry.put((Property)new PropertySimple("uri", (Object)uri));
            entry.put((Property)new PropertySimple("distribution", (Object)distribution));
            entriesList.add((Property)entry);
        }
        return configuration;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
    }
}

