/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.arquillian.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;
import org.rhq.core.pc.PluginContainer;

public abstract class AbstractAnnotatedMethodExecutor<T extends Annotation> {
    private Class<T> annotationClass;
    private static final Comparator<AnnotatedMethod> ORDERING = new Comparator<AnnotatedMethod>(){

        @Override
        public int compare(AnnotatedMethod m1, AnnotatedMethod m2) {
            int o1 = m1.getApplicablTestMethodsAndOrder().getOrder();
            int o2 = m2.getApplicablTestMethodsAndOrder().getOrder();
            if (o1 > 0) {
                if (o2 > 0) {
                    return o1 - o2;
                }
                return -1;
            }
            return o2 > 0 ? 1 : 0;
        }
    };

    protected AbstractAnnotatedMethodExecutor(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    protected abstract ApplicableTestMethodsAndOrder getApplicableTestMethodsAndOrder(T var1);

    protected abstract boolean isApplicableToTest(TestEvent var1);

    protected void process(PluginContainer pluginContainer, TestEvent testEvent) {
        if (this.isApplicableToTest(testEvent)) {
            this.doProcess(testEvent);
        }
    }

    private void doProcess(TestEvent event) {
        Object testCase = event.getTestInstance();
        TestClass testClass = event.getTestClass();
        String testMethodName = event.getTestMethod().getName();
        for (Method m : this.filterAndOrderMethods(testMethodName, testClass.getMethods(this.annotationClass))) {
            try {
                m.invoke(testCase, (Object[])null);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute @" + this.annotationClass.getSimpleName() + " method [" + m + "] - cause: " + e, e);
            }
        }
    }

    private List<Method> filterAndOrderMethods(String targetTestMethodName, Method[] methods) {
        ArrayList<AnnotatedMethod> ordered = new ArrayList<AnnotatedMethod>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            T annotation = methods[i].getAnnotation(this.annotationClass);
            ApplicableTestMethodsAndOrder o = this.getApplicableTestMethodsAndOrder(annotation);
            AnnotatedMethod m = new AnnotatedMethod(methods[i], o);
            ordered.add(m);
        }
        Iterator it = ordered.iterator();
        while (it.hasNext()) {
            AnnotatedMethod m = (AnnotatedMethod)it.next();
            String[] applicableTestMethodNames = m.getApplicablTestMethodsAndOrder().getApplicableTestMethodNames();
            if (applicableTestMethodNames.length <= 0 || Arrays.asList(applicableTestMethodNames).contains(targetTestMethodName)) continue;
            it.remove();
        }
        Collections.sort(ordered, ORDERING);
        ArrayList<Method> ret = new ArrayList<Method>(ordered.size());
        for (AnnotatedMethod m : ordered) {
            ret.add(m.getTestMethod());
        }
        return ret;
    }

    private static class AnnotatedMethod {
        private Method testMethod;
        private ApplicableTestMethodsAndOrder methodsAndOrder;

        public AnnotatedMethod(Method testMethod, ApplicableTestMethodsAndOrder methodsAndOrder) {
            this.testMethod = testMethod;
            this.methodsAndOrder = methodsAndOrder;
        }

        public Method getTestMethod() {
            return this.testMethod;
        }

        public ApplicableTestMethodsAndOrder getApplicablTestMethodsAndOrder() {
            return this.methodsAndOrder;
        }
    }

    protected static class ApplicableTestMethodsAndOrder {
        private String[] applicableTestMethodNames;
        private int order;

        public ApplicableTestMethodsAndOrder(String[] applicableTestMethodNames, int order) {
            this.applicableTestMethodNames = applicableTestMethodNames;
            this.order = order;
        }

        public String[] getApplicableTestMethodNames() {
            return this.applicableTestMethodNames;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

