/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.arquillian.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.rhq.core.util.file.FileUtil;
import org.rhq.test.arquillian.ClearPersistedData;
import org.rhq.test.arquillian.When;
import org.rhq.test.arquillian.impl.RhqAgentPluginContainer;
import org.rhq.test.arquillian.spi.events.PluginContainerDiscovered;

public class DataCleanupExecutor {
    private static final String INVENTORY_DAT = "inventory.dat";
    private static final Log LOG = LogFactory.getLog(DataCleanupExecutor.class);
    @Inject
    private Instance<RhqAgentPluginContainer> pcContainer;

    public void process(@Observes PluginContainerDiscovered pcDiscovered) {
        this.doCleanup(pcDiscovered.getTestMethod(), true);
    }

    public void process(@Observes After test) {
        this.doCleanup(test.getTestMethod(), false);
    }

    private void doCleanup(Method testMethod, boolean isBefore) {
        ClearPersistedData clearData = testMethod.getAnnotation(ClearPersistedData.class);
        if (clearData != null) {
            List<String> plugins;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Clean up for: " + testMethod));
            }
            EnumSet when = this.toEnumSet(When.class, clearData.when());
            boolean hasBefore = when.contains((Object)When.BEFORE_TEST);
            boolean hasAfter = when.contains((Object)When.AFTER_TEST);
            if (!hasBefore && !hasAfter || !hasBefore && isBefore || hasBefore && !hasAfter && !isBefore) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skipping clean up. Currently " + (isBefore ? "before" : "after") + " test but scheduled to run:" + when));
                }
                return;
            }
            LOG.info((Object)"Stopping Plugin Container to clean up data");
            ((RhqAgentPluginContainer)this.pcContainer.get()).stopPc();
            File dataDir = ((RhqAgentPluginContainer)this.pcContainer.get()).getConfiguration().getDataDirectory();
            File tmpDir = ((RhqAgentPluginContainer)this.pcContainer.get()).getConfiguration().getTemporaryDirectory();
            FileUtil.purge((File)tmpDir, (boolean)false);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Purged temp dir");
            }
            if (clearData.ofInventory()) {
                File inventoryDat = new File(dataDir, INVENTORY_DAT);
                if (inventoryDat.exists()) {
                    inventoryDat.delete();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Purged inventory dat");
                }
            }
            if (clearData.ofDrift()) {
                FileUtil.purge((File)new File(dataDir, "changesets"), (boolean)false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Purged drift changesets");
                }
            }
            if ((plugins = Arrays.asList(clearData.ofPlugins())).contains("__ALL__")) {
                this.removeAllDataBut(dataDir, new String[]{INVENTORY_DAT, "changesets"});
            } else {
                for (String n : plugins) {
                    FileUtil.purge((File)new File(dataDir, n), (boolean)true);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Purged plugin dir: " + n));
                }
            }
            LOG.info((Object)"Starting Plugin Container after data cleanup.");
            ((RhqAgentPluginContainer)this.pcContainer.get()).startPc();
        }
    }

    private void removeAllDataBut(File dataDir, final String[] excludedNames) {
        File[] files;
        for (File f : files = dataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (String n : excludedNames) {
                    if (!name.equals(n)) continue;
                    return false;
                }
                return true;
            }
        })) {
            FileUtil.purge((File)f, (boolean)true);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Purged dir: " + f.getName()));
        }
    }

    private <T extends Enum<T>> EnumSet<T> toEnumSet(Class<T> c, T ... values) {
        EnumSet<T> ret = EnumSet.noneOf(c);
        for (T e : values) {
            ret.add(e);
        }
        return ret;
    }
}

