/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas.node;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.node.AugeasNodeBase;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AugeasNodeReal
extends AugeasNodeBase
implements AugeasNode {
    public AugeasNodeReal() {
    }

    public AugeasNodeReal(AugeasNode parentNode, AugeasTree tree, String label, int seq) {
        this.ag = tree;
        this.parentNode = parentNode;
        this.path = parentNode.getPath() + File.separatorChar + parentNode.getLabel() + File.separatorChar;
        this.seq = seq;
    }

    public AugeasNodeReal(AugeasNode parentNode, AugeasTree ag, String fullPath) {
        this.parentNode = parentNode;
        if (fullPath == null) {
            return;
        }
        this.path = fullPath.substring(0, fullPath.lastIndexOf(File.separatorChar) + 1);
        String val = fullPath.substring(fullPath.lastIndexOf(File.separatorChar) + 1, fullPath.length());
        int firstB = val.indexOf("[");
        if (firstB != -1) {
            this.seq = Integer.valueOf(val.substring(firstB + 1, val.indexOf(93)));
            this.label = val.substring(0, firstB);
        } else {
            this.seq = 0;
            this.label = fullPath.substring(fullPath.lastIndexOf(File.separatorChar) + 1);
        }
    }

    public AugeasNodeReal(String path, String label, int seq, String value) {
        this.childNodes = new ArrayList();
        if (path == null) {
            return;
        }
        this.path = path;
        this.value = value;
        this.label = label;
        this.seq = seq;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AugeasNode that = (AugeasNode)obj;
        return this.getFullPath().equals(that.getFullPath());
    }

    @Override
    public String getFullPath() {
        return this.path + this.label + (this.seq != 0 ? "[" + String.valueOf(this.seq) + "]" : "");
    }

    @Override
    public void addChildNode(AugeasNode node) {
        this.childNodes.add(node);
    }

    @Override
    public List<AugeasNode> getChildByLabel(String labelName) {
        List<AugeasNode> nodes = this.getChildNodes();
        ArrayList<AugeasNode> tempNode = new ArrayList<AugeasNode>();
        for (AugeasNode node : nodes) {
            if (!node.getLabel().equals(labelName)) continue;
            tempNode.add(node);
        }
        return tempNode;
    }

    @Override
    public void remove(boolean updateSeq) throws AugeasTreeException {
        this.ag.removeNode(this, updateSeq);
    }

    @Override
    public void setPath(String path) throws AugeasTreeException {
        int end;
        if (path.lastIndexOf(File.separatorChar) == path.length()) {
            end = path.length() - 1;
            this.path = path.substring(0, path.length() - 1);
        } else {
            end = path.length();
            this.path = path;
        }
        AugeasNode parentNode = this.ag.getNode(path.substring(0, end));
        List<AugeasNode> nodes = parentNode.getChildByLabel(this.label);
        if (!nodes.isEmpty()) {
            int indexes = nodes.size();
            this.setSeq(indexes + 1);
        }
        parentNode.addChildNode(this);
        for (AugeasNode nd : this.getChildNodes()) {
            nd.updateFromParent();
        }
    }

    @Override
    public void updateFromParent() {
        AugeasNode node = this.getParentNode();
        if (!this.path.equals(node.getFullPath())) {
            this.path = node.getFullPath();
        }
        for (AugeasNode nd : this.getChildNodes()) {
            nd.updateFromParent();
        }
    }
}

