/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.rhqtransform.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.rhqtransform.AugeasRhqException;
import org.rhq.rhqtransform.AugeasToConfiguration;
import org.rhq.rhqtransform.NameMap;

public class AugeasToConfigurationSimple
implements AugeasToConfiguration {
    private final Log log = LogFactory.getLog(this.getClass());
    protected AugeasTree tree;
    protected NameMap nameMap;

    public void setTree(AugeasTree tree) {
        this.tree = tree;
    }

    public void setNameMap(NameMap nameMap) {
        this.nameMap = nameMap;
    }

    public Configuration loadResourceConfiguration(AugeasNode startNode, ConfigurationDefinition resourceConfigDef) throws AugeasRhqException {
        Configuration resourceConfig = new Configuration();
        Collection propDefs = resourceConfigDef.getPropertyDefinitions().values();
        for (PropertyDefinition propDef : propDefs) {
            resourceConfig.put(this.loadProperty(propDef, startNode));
        }
        return resourceConfig;
    }

    public Property loadProperty(PropertyDefinition propDef, AugeasNode parentNode) throws AugeasRhqException {
        Property prop;
        if (propDef instanceof PropertyDefinitionSimple) {
            prop = this.createPropertySimple((PropertyDefinitionSimple)propDef, parentNode);
        } else if (propDef instanceof PropertyDefinitionMap) {
            prop = this.createPropertyMap((PropertyDefinitionMap)propDef, parentNode);
        } else if (propDef instanceof PropertyDefinitionList) {
            prop = this.createPropertyList((PropertyDefinitionList)propDef, parentNode);
        } else {
            throw new IllegalStateException("Unsupported PropertyDefinition subclass: " + propDef.getClass().getName());
        }
        return prop;
    }

    public Property createPropertySimple(PropertyDefinitionSimple propDefSimple, AugeasNode node) throws AugeasRhqException {
        String value = node.getValue();
        return new PropertySimple(propDefSimple.getName(), (Object)value);
    }

    public PropertyMap createPropertyMap(PropertyDefinitionMap propDefMap, AugeasNode node) throws AugeasRhqException {
        PropertyMap propMap = new PropertyMap(propDefMap.getName());
        for (PropertyDefinition mapEntryPropDef : propDefMap.getPropertyDefinitions().values()) {
            propMap.put(this.loadProperty(mapEntryPropDef, node));
        }
        return propMap;
    }

    public Property createPropertyList(PropertyDefinitionList propDefList, AugeasNode node) throws AugeasRhqException {
        PropertyList propList = new PropertyList(propDefList.getName());
        List<AugeasNode> nodes = this.tree.matchRelative(node, propDefList.getName());
        PropertyDefinition listMemberPropDef = propDefList.getMemberDefinition();
        for (AugeasNode listMemberNode : nodes) {
            propList.add(this.loadProperty(listMemberPropDef, listMemberNode));
        }
        return propList;
    }
}

