/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.rhq.augeas.util.GlobFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Glob {
    private Glob() {
    }

    public static boolean isWildcard(String globPattern) {
        for (char specialChar : GlobFilter.WILDCARD_CHARS) {
            if (globPattern.indexOf(specialChar) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(File rootPath, String globPattern, File file) {
        String rootPortion = Glob.rootPortion(globPattern);
        globPattern = globPattern.substring(rootPortion.length());
        globPattern = new File(rootPath, globPattern).getAbsolutePath();
        return new GlobFilter(globPattern).accept(file);
    }

    public static List<File> match(File parentPath, String globPattern) {
        if (!parentPath.exists()) {
            throw new IllegalArgumentException("Path '" + parentPath + "' does not exist.");
        }
        if (!parentPath.isDirectory()) {
            throw new IllegalArgumentException("Path '" + parentPath + "' is not a directory.");
        }
        String rootPortion = Glob.rootPortion(globPattern);
        globPattern = globPattern.substring(rootPortion.length());
        int specialCharIdx = globPattern.length();
        for (char specialChar : GlobFilter.WILDCARD_CHARS) {
            int idx = globPattern.indexOf(specialChar);
            if (idx < 0 || specialCharIdx <= idx) continue;
            specialCharIdx = idx;
        }
        if (specialCharIdx > 0) {
            int globParentIdx = globPattern.lastIndexOf(File.separatorChar, specialCharIdx);
            if (globParentIdx > 0) {
                parentPath = new File(parentPath, globPattern.substring(0, globParentIdx));
                globPattern = Glob.createGlobPattern(parentPath.getAbsolutePath(), globPattern.substring(globParentIdx));
            } else {
                globPattern = Glob.createGlobPattern(parentPath.getAbsolutePath(), globPattern);
            }
        } else {
            globPattern = Glob.createGlobPattern(parentPath.getAbsolutePath(), globPattern);
        }
        globPattern = new File(globPattern).getAbsolutePath();
        File[] files = parentPath.listFiles(new GlobFilter(globPattern));
        if (files == null) {
            throw new IllegalStateException("Could not list files in " + parentPath);
        }
        return Arrays.asList(files);
    }

    private static String createGlobPattern(String parent, String pattern) {
        if (!parent.endsWith(File.separator)) {
            parent = parent + File.separatorChar;
        }
        return parent + pattern;
    }

    public static List<File> matchAll(File parentPath, String ... globPattern) {
        return Glob.matchAll(parentPath, Arrays.asList(globPattern));
    }

    public static List<File> matchAll(File parentPath, List<String> globPatterns) {
        ArrayList<File> matches = new ArrayList<File>();
        for (String p : globPatterns) {
            matches.addAll(Glob.match(parentPath, p));
        }
        return matches;
    }

    public static void exclude(List<File> matches, String globPattern) {
        GlobFilter filter = new GlobFilter(globPattern);
        Iterator<File> it = matches.iterator();
        while (it.hasNext()) {
            if (!filter.accept(it.next())) continue;
            it.remove();
        }
    }

    public static void excludeAll(List<File> matches, String ... globPattern) {
        Glob.excludeAll(matches, Arrays.asList(globPattern));
    }

    public static void excludeAll(List<File> matches, List<String> globPatterns) {
        for (String p : globPatterns) {
            Glob.exclude(matches, p);
        }
    }

    private static String rootPortion(String path) {
        for (File root : File.listRoots()) {
            if (!path.startsWith(root.getPath())) continue;
            return root.getPath();
        }
        return "";
    }
}

