/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.rhqtransform.impl;

import org.rhq.augeas.AugeasProxy;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.rhqtransform.AugeasRhqException;
import org.rhq.rhqtransform.AugeasToConfiguration;
import org.rhq.rhqtransform.ConfigurationToAugeas;
import org.rhq.rhqtransform.RhqAugeasMapping;
import org.rhq.rhqtransform.impl.AugeasToConfigurationSimple;
import org.rhq.rhqtransform.impl.ConfigurationToAugeasSimple;

public class RhqAugeasMappingSimple
implements RhqAugeasMapping {
    private AugeasToConfiguration augeasToConfiguration;
    private ConfigurationToAugeas configurationToAugeas;
    private String moduleName;

    public RhqAugeasMappingSimple(String moduleName) {
        this.augeasToConfiguration = new AugeasToConfigurationSimple();
        this.configurationToAugeas = new ConfigurationToAugeasSimple();
        this.moduleName = moduleName;
    }

    public RhqAugeasMappingSimple(AugeasToConfiguration toConfig, ConfigurationToAugeas toAugeas, String moduleName) {
        this.augeasToConfiguration = toConfig;
        this.configurationToAugeas = toAugeas;
        this.moduleName = moduleName;
    }

    public void updateAugeas(AugeasProxy component, Configuration config, ConfigurationDefinition configDef) throws AugeasRhqException {
        AugeasTree tree = component.getAugeasTree(this.moduleName, true);
        AugeasNode startNode = this.getStartNode(tree);
        this.configurationToAugeas.updateResourceConfiguration(startNode, configDef, config);
    }

    public Configuration updateConfiguration(AugeasProxy augeasComponent, ConfigurationDefinition configDef) throws AugeasRhqException {
        AugeasTree tree = augeasComponent.getAugeasTree(this.moduleName, true);
        AugeasNode startNode = this.getStartNode(tree);
        return this.augeasToConfiguration.loadResourceConfiguration(startNode, configDef);
    }

    protected AugeasNode getStartNode(AugeasTree tree) throws AugeasRhqException {
        return tree.getRootNode();
    }
}

