/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas.tree;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.rhq.augeas.node.AugeasNode;

public class AugeasNodeBuffer {
    private Map<String, AugeasNode> buffer = new HashMap<String, AugeasNode>();

    public boolean isNodeLoaded(String name) {
        return this.buffer.containsKey(name);
    }

    public AugeasNode getNode(String name) {
        return this.buffer.get(name);
    }

    public void addNode(AugeasNode node) {
        if (!this.isNodeLoaded(node.getFullPath())) {
            this.buffer.put(node.getFullPath(), node);
        }
    }

    public void removeNode(AugeasNode node, boolean updateSeq, boolean lazy) {
        if (this.buffer.containsKey(node.getFullPath())) {
            this.buffer.remove(node.getFullPath());
        }
        if (updateSeq) {
            if (lazy) {
                this.reloadLazy(node);
            } else {
                this.reload(node);
            }
        }
    }

    public void reload(AugeasNode nodes) {
        for (String key : this.buffer.keySet()) {
            AugeasNode nd;
            if (key.equals((nd = this.buffer.get(key)).getFullPath())) continue;
            this.buffer.remove(key);
            this.buffer.put(nd.getFullPath(), nd);
        }
    }

    public void reloadLazy(AugeasNode node) {
        HashMap<String, String> nodesToChange = new HashMap<String, String>();
        ArrayList<String> nodesToChangeSeq = new ArrayList<String>();
        AugeasNode parentNode = node.getParentNode();
        for (String key : this.buffer.keySet()) {
            int endOfSeq;
            String seqNr;
            int seq;
            String labelName;
            int startOfSeq;
            String restOfPath;
            String label;
            int index = key.indexOf(parentNode.getFullPath());
            if (index != 0 || key.length() <= parentNode.getFullPath().length()) continue;
            String localPath = key.substring(parentNode.getFullPath().length());
            int endOfLabel = localPath.indexOf(File.separatorChar);
            if (endOfLabel != -1) {
                label = localPath.substring(0, endOfLabel);
                restOfPath = localPath.substring(endOfLabel + 1, localPath.length() - 1);
            } else {
                label = localPath.substring(0, localPath.length() - 1);
                restOfPath = "";
            }
            if ((startOfSeq = label.indexOf(91)) == -1 || !(labelName = label.substring(0, startOfSeq)).equals(node.getLabel()) || (seq = Integer.valueOf(seqNr = label.substring(startOfSeq, (endOfSeq = label.indexOf(93)) - 1)).intValue()) <= node.getSeq()) continue;
            if (restOfPath.equals("")) {
                nodesToChangeSeq.add(key);
                continue;
            }
            String newPath = parentNode.getFullPath() + File.separator + labelName + "[" + String.valueOf(seq - 1) + "]" + (restOfPath.equals("") ? File.separator + restOfPath : "");
            nodesToChange.put(key, newPath);
        }
        try {
            for (String key : nodesToChange.keySet()) {
                AugeasNode nd = this.buffer.get(key);
                nd.setPath((String)nodesToChange.get(key));
            }
            for (String key : nodesToChangeSeq) {
                AugeasNode nd = this.buffer.get(key);
                nd.setSeq(nd.getSeq() - 1);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

