/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.byteman;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.byteman.agent.submit.Submit;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.plugins.byteman.BytemanAgentComponent;

public class BytemanScriptComponent
implements ResourceComponent<BytemanAgentComponent>,
DeleteResourceFacet {
    static final String PKG_TYPE_NAME_SCRIPT = "bytemanScript";
    private final Log log = LogFactory.getLog(BytemanScriptComponent.class);
    private ResourceContext<BytemanAgentComponent> resourceContext;
    private String scriptContent;
    private List<String> rules;

    public void start(ResourceContext<BytemanAgentComponent> context) {
        this.resourceContext = context;
        this.getAvailability();
    }

    public void stop() {
        this.scriptContent = null;
        this.rules = null;
    }

    public AvailabilityType getAvailability() {
        try {
            Map<String, String> scripts = ((BytemanAgentComponent)this.resourceContext.getParentResourceComponent()).getAllKnownScripts();
            this.scriptContent = scripts != null ? scripts.get(this.resourceContext.getResourceKey()) : null;
            try {
                this.addDeployedScript();
            }
            catch (Throwable t) {
                this.log.warn((Object)"Failed to add managed script to the byteman agent - is it up?", t);
            }
            if (this.scriptContent != null) {
                try {
                    this.rules = this.getBytemanClient().splitAllRulesFromScript(this.scriptContent);
                }
                catch (Exception e) {
                    this.log.warn((Object)"Failed to split the rules from a script - might be a client problem or data corruption");
                    this.rules = null;
                }
                return AvailabilityType.UP;
            }
            this.rules = null;
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }

    public void deleteResource() throws Exception {
        Map allScripts = this.getBytemanClient().getAllScripts();
        String scriptName = this.resourceContext.getResourceKey();
        String scriptRulesContent = (String)allScripts.get(scriptName);
        File scriptFile = null;
        try {
            scriptFile = this.getManagedScriptFile(scriptName);
            if (scriptFile != null && scriptFile.isFile() && !scriptFile.delete()) {
                this.log.warn((Object)("The Byteman script file [" + scriptFile + "] failed to delete"));
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("The Byteman script file [" + scriptFile + "] could not be deleted"), (Throwable)e);
        }
        if (scriptRulesContent != null) {
            HashMap<String, String> scriptRulesToDelete = new HashMap<String, String>(1);
            scriptRulesToDelete.put(scriptName, scriptRulesContent);
            this.getBytemanClient().deleteRules(scriptRulesToDelete);
        }
    }

    public List<String> getRules() {
        return this.rules;
    }

    public Submit getBytemanClient() {
        return ((BytemanAgentComponent)this.resourceContext.getParentResourceComponent()).getBytemanClient();
    }

    protected File getManagedScriptFile(String scriptPath) {
        File scriptsDataDir = ((BytemanAgentComponent)this.resourceContext.getParentResourceComponent()).getScriptsDataDirectory();
        File scriptFile = new File(scriptPath);
        File scriptParentDir = scriptFile.getParentFile();
        boolean isManaged = scriptParentDir != null && scriptsDataDir.getAbsolutePath().equals(scriptParentDir.getAbsolutePath());
        return isManaged ? scriptFile : null;
    }

    protected void addDeployedScript() throws Exception {
        File scriptFile;
        if (this.scriptContent == null && (scriptFile = this.getManagedScriptFile(this.resourceContext.getResourceKey())) != null) {
            this.getBytemanClient().addRulesFromFiles(Arrays.asList(scriptFile.getAbsolutePath()));
            this.scriptContent = new String(StreamUtil.slurp((InputStream)new FileInputStream(scriptFile)));
        }
    }
}

