/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.byteman;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.ClassLoaderFacet;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.byteman.BytemanAgentComponent;

public class BytemanAgentDiscoveryComponent
implements ResourceDiscoveryComponent<BytemanAgentComponent>,
ManualAddFacet<BytemanAgentComponent>,
ClassLoaderFacet<BytemanAgentComponent> {
    private final Log log = LogFactory.getLog(BytemanAgentDiscoveryComponent.class);
    public static final String DEFAULT_BYTEMAN_ADDRESS = "127.0.0.1";
    public static final String DEFAULT_BYTEMAN_PORT = "9091";
    public static final String PLUGIN_CONFIG_PROP_ADDRESS = "listenerAddress";
    public static final String PLUGIN_CONFIG_PROP_PORT = "listenerPort";
    public static final String PLUGIN_CONFIG_PROP_CLIENT_JAR = "bytemanClientJar";
    private static final String DEFAULT_DESCRIPTION = "Byteman agent that is able to perform byte-code manipulation within its JVM";
    private static final String DEFAULT_NAME = "Byteman";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BytemanAgentComponent> context) {
        this.log.info((Object)"Discovering byteman agents");
        HashSet<DiscoveredResourceDetails> set = new HashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        block2: for (ProcessScanResult autoDiscoveryResult : autoDiscoveryResults) {
            String[] cmdline = autoDiscoveryResult.getProcessInfo().getCommandLine();
            if (cmdline == null) continue;
            for (String arg : cmdline) {
                if (!arg.startsWith("-javaagent:") || !arg.contains("byteman") || !arg.contains(".jar")) continue;
                String libPath = arg.substring("-javaagent:".length(), arg.indexOf(".jar") + ".jar".length());
                File libFile = new File(libPath);
                if (libFile.exists()) {
                    libPath = libFile.getAbsolutePath();
                } else {
                    String cwd = autoDiscoveryResult.getProcessInfo().getCurrentWorkingDirectory();
                    libFile = new File(cwd, libPath);
                    if (libFile.exists()) {
                        libPath = libFile.getAbsolutePath();
                    }
                }
                String address = DEFAULT_BYTEMAN_ADDRESS;
                Pattern pattern = Pattern.compile(".*address:([^,]+).*");
                Matcher matcher = pattern.matcher(arg);
                if (matcher.matches() && (address = matcher.group(1)) == null) {
                    this.log.warn((Object)("Address could not be parsed from byteman cmdline: " + arg));
                    address = DEFAULT_BYTEMAN_ADDRESS;
                }
                String port = DEFAULT_BYTEMAN_PORT;
                pattern = Pattern.compile(".*port:(\\d+).*");
                matcher = pattern.matcher(arg);
                if (matcher.matches()) {
                    port = matcher.group(1);
                    try {
                        Integer.parseInt(port);
                    }
                    catch (NumberFormatException e) {
                        this.log.warn((Object)("Port # could not be parsed from byteman cmdline: " + arg));
                        port = DEFAULT_BYTEMAN_PORT;
                    }
                }
                Configuration pluginConfig = context.getDefaultPluginConfiguration();
                pluginConfig.put((Property)new PropertySimple(PLUGIN_CONFIG_PROP_ADDRESS, (Object)address));
                pluginConfig.put((Property)new PropertySimple(PLUGIN_CONFIG_PROP_PORT, (Object)port));
                pluginConfig.put((Property)new PropertySimple(PLUGIN_CONFIG_PROP_CLIENT_JAR, (Object)libPath));
                String key = address + ':' + port;
                String name = DEFAULT_NAME;
                String description = DEFAULT_DESCRIPTION;
                String version = this.getVersion(address, port, libPath);
                DiscoveredResourceDetails details = new DiscoveredResourceDetails(context.getResourceType(), key, name, version, description, pluginConfig, null);
                set.add(details);
                continue block2;
            }
        }
        return set;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfiguration, ResourceDiscoveryContext<BytemanAgentComponent> context) throws InvalidPluginConfigurationException {
        String address = pluginConfiguration.getSimpleValue(PLUGIN_CONFIG_PROP_ADDRESS, null);
        String port = pluginConfiguration.getSimpleValue(PLUGIN_CONFIG_PROP_PORT, null);
        String clientJar = pluginConfiguration.getSimpleValue(PLUGIN_CONFIG_PROP_CLIENT_JAR, null);
        if (address == null) {
            throw new InvalidPluginConfigurationException("Byteman address was not specified");
        }
        if (port == null) {
            throw new InvalidPluginConfigurationException("Byteman port was not specified");
        }
        if (clientJar == null) {
            throw new InvalidPluginConfigurationException("Byteman client jar was not specified");
        }
        try {
            Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new InvalidPluginConfigurationException("Port number was invalid: " + port, (Throwable)e);
        }
        File clientJarFile = new File(clientJar);
        if (!clientJarFile.isFile() || !clientJarFile.canRead()) {
            throw new InvalidPluginConfigurationException("Byteman client jar [" + clientJar + "] cannot be read");
        }
        String key = address + ':' + port;
        String name = DEFAULT_NAME;
        String description = DEFAULT_DESCRIPTION;
        String version = this.getVersion(address, port, clientJar);
        DiscoveredResourceDetails details = new DiscoveredResourceDetails(context.getResourceType(), key, name, version, description, pluginConfiguration, null);
        return details;
    }

    public List<URL> getAdditionalClasspathUrls(ResourceDiscoveryContext<BytemanAgentComponent> context, DiscoveredResourceDetails details) throws Exception {
        PropertySimple clientJarProperty = details.getPluginConfiguration().getSimple(PLUGIN_CONFIG_PROP_CLIENT_JAR);
        if (clientJarProperty == null || clientJarProperty.getStringValue() == null) {
            throw new InvalidPluginConfigurationException("Byteman client jar not specified in plugin configuration");
        }
        String clientJarString = clientJarProperty.getStringValue();
        File clientJarFile = new File(clientJarString);
        if (!clientJarFile.exists()) {
            throw new InvalidPluginConfigurationException("Byteman client jar [" + clientJarString + "] does not exist");
        }
        if (!clientJarFile.canRead()) {
            throw new InvalidPluginConfigurationException("Byteman client jar [" + clientJarString + "] is unreadable");
        }
        ArrayList<URL> list = new ArrayList<URL>(1);
        list.add(clientJarFile.toURI().toURL());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getVersion(String address, String port, String jarPath) {
        String version = null;
        Socket commSocket = null;
        try {
            int portInt = Integer.parseInt(port);
            commSocket = new Socket(address, portInt);
            BufferedReader commInput = new BufferedReader(new InputStreamReader(commSocket.getInputStream()));
            PrintWriter commOutput = new PrintWriter(new OutputStreamWriter(commSocket.getOutputStream()));
            commOutput.println("VERSION");
            commOutput.flush();
            String line = commInput.readLine();
            while (line != null && !line.trim().equals("OK")) {
                version = line.trim();
                line = commInput.readLine();
            }
        }
        catch (Throwable t) {
            version = BytemanAgentDiscoveryComponent.getJarAttribute(jarPath, "Implementation-Version", null);
        }
        finally {
            if (commSocket != null) {
                try {
                    commSocket.close();
                }
                catch (Exception ignore) {}
            }
        }
        if (version == null) {
            version = "0";
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJarAttribute(String jarPath, String attributeName, String defaultValue) {
        String attributeValue = null;
        try {
            JarFile jarFile = new JarFile(jarPath);
            try {
                Manifest manifest = jarFile.getManifest();
                attributeValue = manifest.getMainAttributes().getValue(attributeName);
            }
            finally {
                jarFile.close();
            }
        }
        catch (Throwable t1) {
            // empty catch block
        }
        if (attributeValue == null) {
            attributeValue = defaultValue;
        }
        return attributeValue;
    }
}

