/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.byteman;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.byteman.agent.submit.Submit;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.byteman.BytemanScriptComponent;

public class BytemanRuleComponent
implements ResourceComponent<BytemanScriptComponent> {
    private final Log log = LogFactory.getLog(BytemanRuleComponent.class);
    private ResourceContext<BytemanScriptComponent> resourceContext;

    public void start(ResourceContext<BytemanScriptComponent> context) {
        this.resourceContext = context;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        try {
            String ourKey = this.resourceContext.getResourceKey();
            Submit client = ((BytemanScriptComponent)this.resourceContext.getParentResourceComponent()).getBytemanClient();
            List<String> rules = ((BytemanScriptComponent)this.resourceContext.getParentResourceComponent()).getRules();
            for (String rule : rules) {
                String ruleName = client.determineRuleName(rule);
                if (!ourKey.equals(ruleName)) continue;
                return AvailabilityType.UP;
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }
}

