/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.storage.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.Deployer;
import org.rhq.cassandra.DeploymentOptions;
import org.rhq.cassandra.DeploymentOptionsFactory;
import org.rhq.cassandra.installer.RMIContextFactory;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.storage.installer.StorageInstallerException;
import org.yaml.snakeyaml.Yaml;

public class StorageInstaller {
    public static final int STATUS_NO_ERRORS = 0;
    public static final int STATUS_STORAGE_NOT_RUNNING = 1;
    public static final int STATUS_FAILED_TO_VERIFY_NODE_UP = 2;
    public static final int STATUS_INVALID_FILE_PERMISSIONS = 3;
    public static final int STATUS_DATA_DIR_NOT_EMPTY = 4;
    public static final int STATUS_SHOW_USAGE = 100;
    public static final int STATUS_INVALID_UPGRADE = 5;
    private final String STORAGE_BASEDIR = "rhq-storage";
    private final Log log = LogFactory.getLog(StorageInstaller.class);
    private Options options;
    private File serverBasedir;
    private File storageBasedir;
    private int defaultJmxPort = 7299;
    private int rpcPort = 9160;
    private int defaultNativeTransportPort = 9142;
    private int storagePort = 7100;
    private int sslStoragePort = 7101;
    private File logDir;
    private String dirPrefix = this.isWindows() ? "" : "/var/lib";
    private String commitLogDir = this.dirPrefix + "/rhq/storage/commitlog";
    private String dataDir = this.dirPrefix + "/rhq/storage/data";
    private String savedCachesDir = this.dirPrefix + "/rhq/storage/saved_caches";
    private String defaultHeapSize = "512M";
    private String defaultHeapNewSize = "128M";

    public StorageInstaller() {
        String basedir = System.getProperty("rhq.server.basedir");
        this.serverBasedir = new File(basedir);
        this.storageBasedir = new File(basedir, "rhq-storage");
        this.logDir = new File(this.serverBasedir, "logs");
        Option hostname = new Option("n", "hostname", true, "The hostname or IP address on which the node will listen for requests. If not specified, defaults to the hostname for localhost.");
        hostname.setArgName("HOSTNAME");
        Option seeds = new Option("s", "seeds", true, "A comma-delimited list of hostnames or IP addresses that serve as contact points. Nodes use this list to find each other and to learn the cluster topology. It does not need to specify all nodes in the cluster. Defaults to this node's hostname.");
        seeds.setArgName("SEEDS");
        Option jmxPortOption = new Option("j", "jmx-port", true, "The port on which to listen for JMX connections. Defaults to " + this.defaultJmxPort + ".");
        jmxPortOption.setArgName("PORT");
        Option nativeTransportPortOption = new Option("c", "client-port", true, "The port on which to listen for client requests. Defaults to " + this.defaultNativeTransportPort);
        nativeTransportPortOption.setArgName("PORT");
        Option storagePortOption = new Option(null, "storage-port", true, "The port on which to listen for requests  from other nodes. Defaults to " + this.storagePort);
        storagePortOption.setArgName("PORT");
        Option sslStoragePortOption = new Option(null, "ssl-storage-port", true, "The port on which to listen for encrypted requests from other nodes. Only used when encryption is enabled. Defaults to " + this.sslStoragePort);
        sslStoragePortOption.setArgName("PORT");
        Option startOption = new Option(null, "start", true, "Start the storage node after installing it on disk. Defaults to true.");
        startOption.setArgName("true|false");
        Option checkStatus = new Option(null, "check-status", true, "Check the node status to verify that it is up after starting it. This option is ignored if the start option is not set. Defaults to true.");
        checkStatus.setArgName("true|false");
        Option commitLogOption = new Option(null, "commitlog", true, "The directory where the storage node keeps commit log files. Defaults to " + this.commitLogDir + ".");
        commitLogOption.setArgName("DIR");
        Option dataDirOption = new Option(null, "data", true, "The directory where the storage node keeps data files. Defaults to " + this.dataDir + ".");
        dataDirOption.setArgName("DIR");
        Option savedCachesDirOption = new Option(null, "saved-caches", true, "The directory where the storage node keeps saved cache files. Defaults to " + this.savedCachesDir + ".");
        savedCachesDirOption.setArgName("DIR");
        Option basedirOption = new Option(null, "dir", true, "The directory where the storage node will be installed The default directory will be " + this.storageBasedir);
        Option heapSizeOption = new Option(null, "heap-size", true, "The value to use for both the min and max heap. This value is passed directly to the -Xms and -Xmx options of the Java executable. Defaults to " + this.defaultHeapSize);
        Option heapNewSizeOption = new Option(null, "heap-new-size", true, "The value to use for the new generation of the heap. This value is passed directly to the -Xmn option of the Java executable. Defaults to " + this.defaultHeapNewSize);
        Option stackSizeOption = new Option(null, "stack-size", true, "The value to use for the thread stack size. This value is passed directly to the -Xss option of the Java executable.");
        Option upgradeOption = new Option(null, "upgrade", true, "Upgrades an existing storage node. The directory where the existing RHQ server is installed.");
        upgradeOption.setArgName("RHQ_SERVER_DIR");
        this.options = new Options().addOption(new Option("h", "help", false, "Show this message.")).addOption(hostname).addOption(seeds).addOption(jmxPortOption).addOption(startOption).addOption(checkStatus).addOption(commitLogOption).addOption(dataDirOption).addOption(savedCachesDirOption).addOption(nativeTransportPortOption).addOption(storagePortOption).addOption(sslStoragePortOption).addOption(basedirOption).addOption(heapSizeOption).addOption(heapNewSizeOption).addOption(stackSizeOption).addOption(upgradeOption);
    }

    public int run(org.apache.commons.cli.CommandLine cmdLine) throws Exception {
        int jmxPort;
        String hostname;
        if (cmdLine.hasOption("h")) {
            this.printUsage();
            return 100;
        }
        DeploymentOptionsFactory factory = new DeploymentOptionsFactory();
        DeploymentOptions deploymentOptions = factory.newDeploymentOptions();
        File logFile = new File(this.logDir, "rhq-storage.log");
        if (cmdLine.hasOption("upgrade")) {
            File existingStorageDir = null;
            File upgradeFromDir = new File(cmdLine.getOptionValue("upgrade", ""));
            if (!upgradeFromDir.isDirectory()) {
                this.log.error((Object)"The value passed to the upgrade option is not a directory. The value must be a valid path that points to the base directory of an existing RHQ server installation.");
                return 5;
            }
            existingStorageDir = new File(upgradeFromDir, "rhq-storage");
            if (!existingStorageDir.exists() || !existingStorageDir.isDirectory()) {
                this.log.error((Object)(existingStorageDir + " does not appear to be an existing RHQ storage node installtion. " + "Check the value that was passed to the upgrade option and make sure it specifies the base " + "directory of an existing RHQ server installation."));
                return 5;
            }
            deploymentOptions.setBasedir(this.storageBasedir.getAbsolutePath());
            Deployer deployer = new Deployer();
            deployer.setDeploymentOptions(deploymentOptions);
            this.storageBasedir.mkdirs();
            deployer.unzipDistro();
            deployer.updateFilePerms();
            File oldConfDir = new File(existingStorageDir, "conf");
            File newConfDir = new File(this.storageBasedir, "conf");
            String cassandraYaml = "cassandra.yaml";
            String cassandraEnv = "cassandra-env.sh";
            File cassandraEnvFile = new File(newConfDir, cassandraEnv);
            String log4j = "log4j-server.properties";
            this.replaceFile(new File(oldConfDir, cassandraYaml), new File(newConfDir, cassandraYaml));
            this.replaceFile(new File(oldConfDir, cassandraEnv), cassandraEnvFile);
            this.replaceFile(new File(oldConfDir, log4j), new File(newConfDir, log4j));
            this.log.info((Object)"Finished installing RHQ Storage Node.");
            this.log.info((Object)"Updating rhq-server.properties...");
            File yamlFile = new File(newConfDir, "cassandra.yaml");
            Yaml yaml = new Yaml();
            Map config = (Map)yaml.load((InputStream)new FileInputStream(yamlFile));
            hostname = (String)config.get("listen_address");
            jmxPort = this.parseJmxPort(cassandraEnvFile);
        } else {
            if (cmdLine.hasOption("dir")) {
                File basedir = new File(cmdLine.getOptionValue("dir"));
                deploymentOptions.setBasedir(basedir.getAbsolutePath());
            }
            hostname = cmdLine.hasOption("n") ? cmdLine.getOptionValue("n") : InetAddress.getLocalHost().getHostAddress();
            deploymentOptions.setListenAddress(hostname);
            deploymentOptions.setRpcAddress(hostname);
            String seeds = cmdLine.getOptionValue("seeds", hostname);
            deploymentOptions.setSeeds(seeds);
            this.commitLogDir = cmdLine.getOptionValue("commitlog", this.commitLogDir);
            this.dataDir = cmdLine.getOptionValue("data", this.dataDir);
            this.savedCachesDir = cmdLine.getOptionValue("saved-caches", this.savedCachesDir);
            File commitLogDirFile = new File(this.commitLogDir);
            File dataDirFile = new File(this.dataDir);
            File savedCachesDirFile = new File(this.savedCachesDir);
            if (!this.isDirectoryEmpty(commitLogDirFile)) {
                this.log.error((Object)("Commitlog directory is not empty. It should not exist for a new Storage Node [" + commitLogDirFile.getAbsolutePath() + "]"));
                return 4;
            }
            if (!this.isDirectoryEmpty(dataDirFile)) {
                this.log.error((Object)("Data directory is not empty. It should not exist for a new Storage Node [" + dataDirFile.getAbsolutePath() + "]"));
                return 4;
            }
            if (!this.isDirectoryEmpty(savedCachesDirFile)) {
                this.log.error((Object)("Saved caches directory is not empty. It should not exist for a new Storage Node [" + savedCachesDirFile.getAbsolutePath() + "]"));
                return 4;
            }
            jmxPort = this.getPort(cmdLine, "jmx-port", this.defaultJmxPort);
            int nativeTransportPort = this.getPort(cmdLine, "client-port", this.defaultNativeTransportPort);
            deploymentOptions.setCommitLogDir(this.commitLogDir);
            deploymentOptions.setDataDir(this.dataDir);
            deploymentOptions.setSavedCachesDir(this.savedCachesDir);
            deploymentOptions.setLogFileName(logFile.getPath());
            deploymentOptions.setLoggingLevel("INFO");
            deploymentOptions.setRpcPort(Integer.valueOf(this.rpcPort));
            deploymentOptions.setJmxPort(Integer.valueOf(jmxPort));
            deploymentOptions.setNativeTransportPort(Integer.valueOf(nativeTransportPort));
            deploymentOptions.setStoragePort(Integer.valueOf(this.getPort(cmdLine, "storage-port", this.storagePort)));
            deploymentOptions.setSslStoragePort(Integer.valueOf(this.getPort(cmdLine, "ssl-storage-port", this.sslStoragePort)));
            deploymentOptions.setNativeTransportMaxThreads(Integer.valueOf(128));
            deploymentOptions.setHeapSize(cmdLine.getOptionValue("heap-size", this.defaultHeapSize));
            deploymentOptions.setHeapNewSize(cmdLine.getOptionValue("heap-new-size", this.defaultHeapNewSize));
            if (cmdLine.hasOption("stack-size")) {
                deploymentOptions.setStackSize(cmdLine.getOptionValue("stack-size"));
            }
            deploymentOptions.load();
            ArrayList<String> errors = new ArrayList<String>();
            this.checkPerms(this.options.getOption("saved-caches"), this.savedCachesDir, errors);
            this.checkPerms(this.options.getOption("commitlog"), this.commitLogDir, errors);
            this.checkPerms(this.options.getOption("data"), this.dataDir, errors);
            if (!errors.isEmpty()) {
                this.log.error((Object)"Problems have been detected with one or more of the directories in which the storage node will need to store data");
                for (String error : errors) {
                    this.log.error((Object)error);
                }
                this.log.error((Object)"The storage installer will now exit due to previous errors.");
                return 3;
            }
            Deployer deployer = new Deployer();
            deployer.setDeploymentOptions(deploymentOptions);
            this.storageBasedir.mkdirs();
            deployer.unzipDistro();
            deployer.applyConfigChanges();
            deployer.updateFilePerms();
            this.log.info((Object)"Finished installing RHQ Storage Node.");
            PropertiesFileUpdate serverPropertiesUpdater = this.getServerProperties();
            this.log.info((Object)"Updating rhq-server.properties...");
            serverPropertiesUpdater.update("rhq.cassandra.seeds", this.getSeedsProperty(hostname, jmxPort, nativeTransportPort));
        }
        boolean startNode = Boolean.parseBoolean(cmdLine.getOptionValue("start", "true"));
        if (startNode) {
            this.log.info((Object)"Starting RHQ Storage Node");
            String startupErrors = this.startNode(deploymentOptions);
            if (startupErrors == null) {
                boolean checkStatus = Boolean.parseBoolean(cmdLine.getOptionValue("check-status", "true"));
                if (checkStatus || this.isWindows()) {
                    if (this.verifyNodeIsUp(hostname, jmxPort, 5, 3000L)) {
                        this.log.info((Object)"RHQ Storage Node is up and running and ready to service client requests");
                        this.log.info((Object)"Installation of the storage node has completed successfully.");
                        return 0;
                    }
                    this.log.error((Object)"Could not verify that the node is up and running.");
                    this.log.error((Object)("Check the log file at " + logFile + " for errors."));
                    this.log.error((Object)"The storage installer will now exit");
                    return 2;
                }
                if (this.isRunning()) {
                    this.log.info((Object)"Installation of the storage node is complete. The node should be up and running");
                    return 0;
                }
                this.log.warn((Object)("Installation of the storage node is complete, but the node does not appear to be running. No start up errors were reported.  Check the log file at " + logFile + " for any other possible errors."));
                return 1;
            }
            boolean foundLinkError = false;
            boolean harmless = true;
            if (startupErrors.contains("UnsatisfiedLinkError: no snappyjava")) {
                this.log.info((Object)"Could not find snappyjava in library path. Will not compress system tables.");
                this.log.info((Object)"Installation of the storage node is complete");
                foundLinkError = true;
            }
            if (!foundLinkError) {
                this.log.error((Object)("The storage node reported the following errors while trying to start:\n\n" + startupErrors + "\n\n"));
                harmless = false;
            }
            if (startupErrors.contains("java.net.BindException: Address already in use")) {
                this.log.error((Object)"This error may indicate a conflict for the JMX port.");
            }
            if (!harmless) {
                this.log.error((Object)"Please review your configuration for possible sources of errors such as port conflicts or invalid arguments/options passed to the java executable.");
                this.log.error((Object)"The storage installer will now exit.");
                return 1;
            }
            return 0;
        }
        this.log.info((Object)"Installation of the storage node is complete");
        return 0;
    }

    private boolean isDirectoryEmpty(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            return files == null || files.length == 0;
        }
        return true;
    }

    private int getPort(org.apache.commons.cli.CommandLine cmdLine, String option, int defaultValue) {
        return Integer.parseInt(cmdLine.getOptionValue(option, Integer.toString(defaultValue)));
    }

    private void checkPerms(Option option, String path, List<String> errors) {
        File dir = new File(path);
        if (dir.exists()) {
            if (dir.isFile()) {
                errors.add(path + " is not a directory. Use the --" + option.getLongOpt() + " to change this value.");
            }
        } else {
            File parent = this.findParentDir(new File(path));
            if (!parent.canWrite()) {
                errors.add("The user running this installer does not appear to have write permissions to " + parent + ". Either make sure that the user running the storage node has write permissions or use the --" + option.getLongOpt() + " to change this value.");
            }
        }
    }

    private File findParentDir(File path) {
        File dir = path;
        while (!dir.exists()) {
            dir = dir.getParentFile();
        }
        return dir;
    }

    private PropertiesFileUpdate getServerProperties() {
        String sysprop = System.getProperty("rhq.server.properties-file");
        if (sysprop == null) {
            throw new RuntimeException("The required system property [rhq.server.properties] is not defined.");
        }
        File file = new File(sysprop);
        if (!file.exists() || !file.isFile()) {
            throw new RuntimeException("System property [" + sysprop + "] points to in invalid file.");
        }
        return new PropertiesFileUpdate(file.getAbsolutePath());
    }

    private String getSeedsProperty(String hostname, int jmxPort, int nativeTransportPort) {
        return hostname + "|" + jmxPort + "|" + nativeTransportPort;
    }

    private String startNode(DeploymentOptions deploymentOptions) throws Exception {
        if (this.isWindows()) {
            File basedir = new File(System.getProperty("rhq.server.basedir"));
            basedir = null == basedir ? new File(deploymentOptions.getBasedir()).getParentFile() : basedir;
            File binDir = new File(basedir, "bin");
            CommandLine cmdLine = new CommandLine("cmd.exe");
            cmdLine.addArgument("/C");
            cmdLine.addArgument("rhq-storage.bat");
            cmdLine.addArgument("stop");
            String errOutput = this.exec(binDir, cmdLine);
            if (!errOutput.isEmpty()) {
                return errOutput;
            }
            cmdLine = new CommandLine("cmd.exe");
            cmdLine.addArgument("/C");
            cmdLine.addArgument("rhq-storage.bat");
            cmdLine.addArgument("remove");
            errOutput = this.exec(binDir, cmdLine);
            if (!errOutput.isEmpty()) {
                return errOutput;
            }
            cmdLine = new CommandLine("cmd.exe");
            cmdLine.addArgument("/C");
            cmdLine.addArgument("rhq-storage.bat");
            cmdLine.addArgument("install");
            errOutput = this.exec(binDir, cmdLine);
            if (!errOutput.isEmpty()) {
                return errOutput;
            }
            cmdLine = new CommandLine("cmd.exe");
            cmdLine.addArgument("/C");
            cmdLine.addArgument("rhq-storage.bat");
            cmdLine.addArgument("start");
            errOutput = this.exec(binDir, cmdLine);
            if (!errOutput.isEmpty()) {
                return errOutput;
            }
        } else {
            File basedir = new File(deploymentOptions.getBasedir());
            File binDir = new File(basedir, "bin");
            CommandLine cmdLine = new CommandLine("./cassandra");
            cmdLine.addArgument("-p");
            cmdLine.addArgument(new File(binDir, "cassandra.pid").getAbsolutePath());
            String errOutput = this.exec(binDir, cmdLine);
            if (!errOutput.isEmpty()) {
                return errOutput;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String exec(File workingDir, CommandLine cmdLine) throws Exception {
        DefaultExecutor executor = new DefaultExecutor();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        NullOutputStream nullOs = new NullOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)new NullOutputStream(), (OutputStream)buffer);
        executor.setWorkingDirectory(workingDir);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        String result = "";
        try {
            executor.execute(cmdLine);
            result = buffer.toString();
        }
        finally {
            try {
                buffer.close();
                nullOs.close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    private boolean isWindows() {
        String operatingSystem = System.getProperty("os.name").toLowerCase(Locale.US);
        return operatingSystem.contains("windows");
    }

    private boolean isRunning() {
        File binDir = new File(this.storageBasedir, "bin");
        return new File(binDir, "cassandra.pid").exists();
    }

    private boolean verifyNodeIsUp(String address, int jmxPort, int retries, long timeout) throws Exception {
        String url = "service:jmx:rmi:///jndi/rmi://" + address + ":" + jmxPort + "/jmxrmi";
        JMXServiceURL serviceURL = new JMXServiceURL(url);
        JMXConnector connector = null;
        MBeanServerConnection serverConnection = null;
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("java.naming.factory.initial", RMIContextFactory.class.getName());
        for (int i = 0; i < retries; ++i) {
            try {
                connector = JMXConnectorFactory.connect(serviceURL, env);
                serverConnection = connector.getMBeanServerConnection();
                ObjectName storageService = new ObjectName("org.apache.cassandra.db:type=StorageService");
                Boolean nativeTransportRunning = (Boolean)serverConnection.getAttribute(storageService, "NativeTransportRunning");
                return nativeTransportRunning;
            }
            catch (Exception e) {
                if (i < retries) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"The storage node is not up.", (Throwable)e);
                    } else {
                        Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
                        this.log.info((Object)("The storage node is not up: " + rootCause.getClass().getName() + ": " + rootCause.getMessage()));
                    }
                    this.log.info((Object)("Checking storage node status again in " + timeout * (long)(i + 1) + " ms..."));
                }
                Thread.sleep(timeout * (long)(i + 1));
                continue;
            }
        }
        return false;
    }

    private void replaceFile(File oldFile, File newFile) throws IOException {
        this.log.info((Object)("Copying " + oldFile + " to " + newFile));
        if (!oldFile.exists()) {
            this.log.warn((Object)(oldFile + " does not exist. " + newFile.getName() + " will be created."));
        } else {
            newFile.delete();
            try {
                FileUtil.copyFile((File)oldFile, (File)newFile);
            }
            catch (IOException e) {
                this.log.error((Object)("There was an error while copying " + oldFile + " to " + " " + newFile), (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int parseJmxPort(File cassandraEnvFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void printUsage() {
        Options options = this.getOptions();
        HelpFormatter helpFormatter = new HelpFormatter();
        String syntax = "rhq-storage-installer.sh|bat [options]";
        String header = "";
        helpFormatter.printHelp(syntax, header, options, null);
    }

    public Options getOptions() {
        return this.options;
    }

    public static void main(String[] args) throws Exception {
        StorageInstaller installer = new StorageInstaller();
        installer.log.info((Object)"Running RHQ Storage Node installer...");
        try {
            PosixParser parser = new PosixParser();
            org.apache.commons.cli.CommandLine cmdLine = parser.parse(installer.getOptions(), args);
            int status = installer.run(cmdLine);
            System.exit(status);
        }
        catch (StorageInstallerException e) {
            installer.log.warn((Object)e.getMessage());
            for (String error : e.getErrors()) {
                installer.log.error((Object)error);
            }
            installer.log.error((Object)"The storage installer is exiting due to previous errors.");
            System.exit(1);
        }
        catch (ParseException e) {
            installer.printUsage();
            System.exit(100);
        }
    }
}

