/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.rhq.core.util.TokenReplacingReader;

public class TokenReplacingProperties
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    private Map<String, String> wrapped;
    private Map<Object, String> resolved = new HashMap<Object, String>();

    public TokenReplacingProperties(Map<String, String> wrapped) {
        this.wrapped = wrapped;
    }

    public TokenReplacingProperties(Properties properties) {
        Properties map;
        this.wrapped = map = properties;
    }

    @Override
    public String get(Object key) {
        if (this.resolved.containsKey(key)) {
            return this.resolved.get(key);
        }
        String rawValue = this.getRaw(key);
        if (rawValue == null) {
            return null;
        }
        String ret = this.readAll(new TokenReplacingReader(new StringReader(rawValue.toString()), this));
        this.resolved.put(key, ret);
        return ret;
    }

    public String getRaw(Object key) {
        return this.wrapped.get(key);
    }

    @Override
    public String put(String key, String value) {
        this.resolved.remove(key);
        return this.wrapped.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (String string : m.keySet()) {
            this.resolved.remove(string);
        }
        this.wrapped.putAll(m);
    }

    public void putAll(Properties properties) {
        for (String propName : properties.stringPropertyNames()) {
            this.put(propName, properties.getProperty(propName));
        }
    }

    @Override
    public void clear() {
        this.wrapped.clear();
        this.resolved.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    public boolean containsValue(Object value) {
        for (String key : this.keySet()) {
            String thisVal = this.get(key);
            if (!(thisVal == null ? value == null : thisVal.equals(value))) continue;
            return true;
        }
        return false;
    }

    public boolean containsRawValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> ret = new HashSet<Map.Entry<String, String>>();
        for (Map.Entry<String, String> entry : this.wrapped.entrySet()) {
            ret.add(new Entry(entry, true));
        }
        return ret;
    }

    public Set<Map.Entry<String, String>> getRawEntrySet() {
        HashSet<Map.Entry<String, String>> ret = new HashSet<Map.Entry<String, String>>();
        for (Map.Entry<String, String> entry : this.wrapped.entrySet()) {
            ret.add(new Entry(entry, false));
        }
        return ret;
    }

    @Override
    public String remove(Object key) {
        this.resolved.remove(key);
        return this.wrapped.remove(key).toString();
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.keySet()) {
            ret.add(this.get(key));
        }
        return ret;
    }

    public Collection<String> getRawValues() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.keySet()) {
            ret.add(this.wrapped.get(key));
        }
        return ret;
    }

    private String readAll(Reader rdr) {
        int in = -1;
        StringBuilder bld = new StringBuilder();
        try {
            while ((in = rdr.read()) != -1) {
                bld.append((char)in);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception while reading a string.", e);
        }
        return bld.toString();
    }

    private class Entry
    implements Map.Entry<String, String> {
        private Map.Entry<String, String> wrapped;
        private boolean process;

        public Entry(Map.Entry<String, String> wrapped, boolean process) {
            this.wrapped = wrapped;
            this.process = process;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            String key = this.wrapped.getKey();
            String otherKey = other.getKey();
            String value = this.getValue();
            String otherValue = other.getValue();
            return (key == null ? otherKey == null : key.equals(otherKey)) && (value == null ? otherValue == null : value.equals(otherValue));
        }

        @Override
        public String getKey() {
            return this.wrapped.getKey();
        }

        @Override
        public String getValue() {
            if (this.process) {
                return TokenReplacingProperties.this.get(this.wrapped.getKey());
            }
            return this.wrapped.getValue();
        }

        @Override
        public int hashCode() {
            String key = this.wrapped.getKey();
            String value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        @Override
        public String setValue(String value) {
            TokenReplacingProperties.this.resolved.remove(this.wrapped.getKey());
            return this.wrapped.setValue(value);
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }
}

