/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.exception;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;

public class ThrowableUtil {
    private static final String EXCEPTION_WAS_NULL = ">> exception was null <<";
    private static final String DOTS = " ... ";
    private static final String ARROW = " -> ";

    private ThrowableUtil() {
    }

    public static String getAllMessages(Throwable t, boolean includeExceptionName) {
        StringBuffer ret_message = new StringBuffer();
        if (t != null) {
            String[] msgs = ThrowableUtil.getAllMessagesArray(t, includeExceptionName);
            ret_message.append(msgs[0]);
            for (int i = 1; i < msgs.length; ++i) {
                ret_message.append(ARROW);
                ret_message.append(msgs[i]);
            }
        } else {
            ret_message.append(EXCEPTION_WAS_NULL);
        }
        return ret_message.toString();
    }

    public static final String getAllMessages(Throwable t, boolean includeExceptionNames, int maxSize) {
        int curIdx;
        if (maxSize < 0) {
            return ThrowableUtil.getAllMessages(t, includeExceptionNames);
        }
        if (t == null) {
            return EXCEPTION_WAS_NULL;
        }
        int arrowLength = ARROW.length();
        int dotsLength = DOTS.length();
        StringBuilder bld = new StringBuilder();
        String[] msgs = ThrowableUtil.getAllMessagesArray(t, includeExceptionNames);
        int maxDottedSize = maxSize - msgs[msgs.length - 1].length() - dotsLength;
        int maxFullSize = maxDottedSize + dotsLength - arrowLength;
        if (msgs.length == 1 || maxDottedSize < 0) {
            return msgs[msgs.length - 1];
        }
        int maxIdx = msgs.length - 1;
        int lastIdx = maxIdx - 1;
        int curLen = msgs[0].length();
        if (curLen <= maxDottedSize) {
            bld.append(msgs[0]);
        }
        for (curIdx = 1; curIdx < maxIdx; ++curIdx) {
            int lenIncr = arrowLength + msgs[curIdx].length();
            if (curIdx == lastIdx ? curLen + lenIncr > maxFullSize : curLen + lenIncr > maxDottedSize) break;
            bld.append(ARROW);
            bld.append(msgs[curIdx]);
            curLen += lenIncr;
        }
        if (curIdx < msgs.length - 1) {
            bld.append(DOTS);
        } else {
            bld.append(ARROW);
        }
        bld.append(msgs[msgs.length - 1]);
        return bld.toString();
    }

    public static String getAllMessages(Throwable t) {
        return ThrowableUtil.getAllMessages(t, true);
    }

    public static String[] getAllMessagesArray(Throwable t, boolean includeExceptionName) {
        ArrayList<String> list = new ArrayList<String>();
        if (t != null) {
            String msg;
            String tMessage = t.getMessage();
            if (includeExceptionName) {
                msg = t.getClass().getName() + ":" + tMessage;
            } else {
                String string = msg = tMessage != null ? tMessage : t.getClass().getName();
            }
            if (t instanceof SQLException) {
                msg = msg + "[SQLException=" + ThrowableUtil.getAllSqlExceptionMessages((SQLException)t, false) + "]";
            }
            list.add(msg);
            while (t.getCause() != null && t != t.getCause()) {
                t = t.getCause();
                tMessage = t.getMessage();
                if (includeExceptionName) {
                    msg = t.getClass().getName() + ":" + tMessage;
                } else {
                    String string = msg = tMessage != null ? tMessage : t.getClass().getName();
                }
                if (t instanceof SQLException) {
                    msg = msg + "[SQLException=" + ThrowableUtil.getAllSqlExceptionMessages((SQLException)t, false) + "]";
                }
                list.add(msg);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getAllMessagesArray(Throwable t) {
        return ThrowableUtil.getAllMessagesArray(t, true);
    }

    public static String getAllSqlExceptionMessages(SQLException t, boolean includeExceptionName) {
        StringBuffer ret_message = new StringBuffer();
        if (t != null) {
            String[] msgs = ThrowableUtil.getAllSqlExceptionMessagesArray(t, includeExceptionName);
            ret_message.append(msgs[0]);
            for (int i = 1; i < msgs.length; ++i) {
                ret_message.append(ARROW);
                ret_message.append(msgs[i]);
            }
        } else {
            ret_message.append(">> sql exception was null <<");
        }
        return ret_message.toString();
    }

    public static String getAllSqlExceptionMessages(SQLException t) {
        return ThrowableUtil.getAllSqlExceptionMessages(t, true);
    }

    public static String[] getAllSqlExceptionMessagesArray(SQLException t, boolean includeExceptionName) {
        ArrayList<String> list = new ArrayList<String>();
        if (t != null) {
            String tMessage = t.getMessage();
            if (includeExceptionName) {
                list.add(t.getClass().getName() + ":" + tMessage);
            } else {
                list.add(tMessage != null ? tMessage : t.getClass().getName());
            }
            while (t.getNextException() != null && t != t.getNextException()) {
                t = t.getNextException();
                tMessage = t.getMessage();
                String msg = includeExceptionName ? t.getClass().getName() + ":" + tMessage : (tMessage != null ? tMessage : t.getClass().getName());
                list.add(msg + "(error-code=" + t.getErrorCode() + ",sql-state=" + t.getSQLState() + ")");
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getAllSqlExceptionMessagesArray(SQLException t) {
        return ThrowableUtil.getAllSqlExceptionMessagesArray(t, true);
    }

    public static String getStackAsString(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    public static String getFilteredStackAsString(Throwable t) {
        return ThrowableUtil.getFilteredStackAsString(t, "org.rhq");
    }

    public static String getFilteredStackAsString(Throwable t, String filter) {
        StringBuilder smallStack = new StringBuilder();
        StackTraceElement[] stack = null == t ? new Exception().getStackTrace() : t.getStackTrace();
        for (int i = 1; i < stack.length; ++i) {
            StackTraceElement ste = stack[i];
            if (!ste.getClassName().startsWith(filter)) continue;
            smallStack.append(ste.toString());
            smallStack.append("\n");
        }
        return smallStack.toString();
    }

    public static String getRootMessage(Throwable t) {
        String rootMessage = (t = ThrowableUtil.getRootCause(t)).getMessage();
        return rootMessage != null ? rootMessage : t.getClass().getName();
    }

    public static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null && t != t.getCause()) {
            t = t.getCause();
        }
        return t;
    }
}

