/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jmx.JMXDiscoveryComponent;

public class CassandraNodeDiscoveryComponent
extends JMXDiscoveryComponent {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        List processScanResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult processScanResult : processScanResults) {
            DiscoveredResourceDetails discoveredDetails = this.getDetails(context, processScanResult);
            if (discoveredDetails == null) continue;
            details.add(discoveredDetails);
        }
        return details;
    }

    private DiscoveredResourceDetails getDetails(ResourceDiscoveryContext<?> context, ProcessScanResult processScanResult) {
        ProcessInfo processInfo = processScanResult.getProcessInfo();
        String jmxPort = null;
        for (String arg : processInfo.getCommandLine()) {
            if (!arg.startsWith("-Dcom.sun.management.jmxremote.port")) continue;
            String[] jmxPortArg = arg.split("=");
            jmxPort = jmxPortArg[1];
            break;
        }
        if (jmxPort == null) {
            return null;
        }
        String resourceKey = "CassandraDaemon:" + jmxPort;
        String resourceName = "CassandraDaemon";
        Configuration pluginConfig = new Configuration();
        pluginConfig.put((Property)new PropertySimple("type", (Object)J2SE5ConnectionTypeDescriptor.class.getName()));
        pluginConfig.put((Property)new PropertySimple("connectorAddress", (Object)("service:jmx:rmi:///jndi/rmi://127.0.0.1:" + jmxPort + "/jmxrmi")));
        String path = processInfo.getExecutable().getCwd();
        pluginConfig.put((Property)new PropertySimple("baseDir", (Object)new File(path).getParentFile().getAbsolutePath()));
        pluginConfig.put((Property)new PropertySimple("thriftPort", (Object)"9160"));
        return new DiscoveredResourceDetails(context.getResourceType(), resourceKey, resourceName, null, null, pluginConfig, processInfo);
    }
}

