/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.io.File;
import java.util.Map;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.cassandra.CassandraNodeComponent;
import org.rhq.plugins.jmx.JMXComponent;

public class KeyspaceComponent
implements ResourceComponent<ResourceComponent<?>>,
ConfigurationFacet,
JMXComponent<ResourceComponent<?>>,
OperationFacet {
    private static final String STORAGE_SERVICE_BEAN = "org.apache.cassandra.db:type=StorageService";
    private static final String COMPACT_OPERATION = "forceTableCompaction";
    private static final String REPAIR_OPERATION = "forceTableRepair";
    private ResourceContext<ResourceComponent<?>> context;

    public void start(ResourceContext<ResourceComponent<?>> context) throws Exception {
        this.context = context;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return this.context.getParentResourceComponent().getAvailability();
    }

    public EmsConnection getEmsConnection() {
        JMXComponent parent = (JMXComponent)this.context.getParentResourceComponent();
        return parent.getEmsConnection();
    }

    public Configuration loadResourceConfiguration() throws Exception {
        KeyspaceDefinition keyspaceDef = this.getKeyspaceDefinition();
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("name", (Object)keyspaceDef.getName()));
        config.put((Property)new PropertySimple("replicationFactor", (Object)keyspaceDef.getReplicationFactor()));
        config.put((Property)new PropertySimple("strategyClass", (Object)keyspaceDef.getStrategyClass()));
        config.put((Property)new PropertySimple("durableWrites", (Object)keyspaceDef.isDurableWrites()));
        PropertyList list = new PropertyList("strategyOptions");
        Map strategyOptions = keyspaceDef.getStrategyOptions();
        for (String optionName : strategyOptions.keySet()) {
            PropertyMap map = new PropertyMap("strategyOptionsMap");
            map.put((Property)new PropertySimple("strategyOptionName", (Object)optionName));
            map.put((Property)new PropertySimple("strategyOptionValue", strategyOptions.get(optionName)));
            list.add((Property)map);
        }
        config.put((Property)list);
        config.put((Property)this.getKeySpaceDataFileLocations());
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.setStatus(ConfigurationUpdateStatus.NOCHANGE);
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("repair")) {
            return this.repairKeyspace(new String[0]);
        }
        if (name.equals("compact")) {
            return this.compactKeyspace(new String[0]);
        }
        if (name.equals("takeSnapshot")) {
            return this.takeSnapshot(parameters, new String[0]);
        }
        OperationResult failedOperation = new OperationResult();
        failedOperation.setErrorMessage("Operation not implemented.");
        return failedOperation;
    }

    public OperationResult repairKeyspace(String ... columnFamilies) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(REPAIR_OPERATION, new Class[]{String.class, Boolean.TYPE, String[].class});
        String keyspace = this.context.getResourceKey();
        if (columnFamilies == null) {
            columnFamilies = new String[]{};
        }
        operation.invoke(new Object[]{keyspace, true, columnFamilies});
        return new OperationResult();
    }

    public OperationResult compactKeyspace(String ... columnFamilies) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(COMPACT_OPERATION, new Class[]{String.class, String[].class});
        String keyspace = this.context.getResourceKey();
        if (columnFamilies == null) {
            columnFamilies = new String[]{};
        }
        operation.invoke(new Object[]{keyspace, new String[0]});
        return new OperationResult();
    }

    public KeyspaceDefinition getKeyspaceDefinition() {
        return this.getThriftConnection().describeKeyspace(this.context.getResourceKey());
    }

    public OperationResult takeSnapshot(Configuration parameters, String ... columnFamilies) {
        String keyspace = this.context.getResourceKey();
        String snapshotName = parameters.getSimpleValue("snapshotName");
        if (snapshotName == null || snapshotName.trim().isEmpty()) {
            snapshotName = System.currentTimeMillis() + "";
        }
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        if (columnFamilies == null || columnFamilies.length == 0) {
            EmsOperation operation = emsBean.getOperation("takeSnapshot", new Class[]{String.class, String[].class});
            operation.invoke(new Object[]{snapshotName, new String[]{keyspace}});
        } else {
            EmsOperation operation = emsBean.getOperation("takeColumnFamilySnapshot", new Class[]{String.class, String.class, String.class});
            for (String columnFamily : columnFamilies) {
                operation.invoke(new Object[]{keyspace, columnFamily, snapshotName});
            }
        }
        return new OperationResult();
    }

    public PropertyList getKeySpaceDataFileLocations() {
        String[] dirs;
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsAttribute attribute = emsBean.getAttribute("AllDataFileLocations");
        PropertyList list = new PropertyList("keyspaceFileLocations");
        for (String dir : dirs = (String[])attribute.getValue()) {
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            list.add((Property)new PropertySimple("directory", (Object)(dir + this.context.getResourceKey())));
        }
        return list;
    }

    public PropertySimple getCommitLogProperty() {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsAttribute attribute = emsBean.getAttribute("CommitLogLocation");
        return new PropertySimple("CommitLogLocation", attribute.refresh());
    }

    public boolean clearCommitLog() {
        File[] commitLogFiles;
        PropertySimple commitLogProperty = this.getCommitLogProperty();
        File commitLogFolder = new File(commitLogProperty.getStringValue());
        for (File file : commitLogFiles = commitLogFolder.listFiles()) {
            file.delete();
        }
        return true;
    }

    public CassandraNodeComponent getCassandraNodeComponent() {
        return (CassandraNodeComponent)this.context.getParentResourceComponent();
    }

    protected EmsBean loadBean(String objectName) {
        EmsConnection emsConnection = this.getEmsConnection();
        if (emsConnection != null) {
            EmsBean bean = emsConnection.getBean(objectName);
            if (bean == null) {
                emsConnection.queryBeans(objectName);
                bean = emsConnection.getBean(objectName);
            }
            return bean;
        }
        return null;
    }

    public Cluster getThriftConnection() {
        CassandraNodeComponent parent = (CassandraNodeComponent)this.context.getParentResourceComponent();
        return parent.getThriftConnection();
    }
}

