/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.ResultState;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="AlertNotificationLog.deleteByAlertCtime", query="DELETE AlertNotificationLog anl  WHERE anl.id IN (SELECT an.id FROM Alert a JOIN a.alertNotificationLogs an WHERE a.ctime BETWEEN :begin AND :end)"), @NamedQuery(name="AlertNotificationLog.deleteByResource", query="DELETE AlertNotificationLog anl WHERE anl.id IN (SELECT an.id FROM Alert a JOIN a.alertNotificationLogs an JOIN a.alertDefinition def WHERE def.resource.id = :resourceId)"), @NamedQuery(name="AlertNotificationLog.deleteByResources", query="DELETE AlertNotificationLog anl WHERE anl.id IN (SELECT an.id FROM Alert a JOIN a.alertNotificationLogs an JOIN a.alertDefinition def WHERE def.resource.id IN ( :resourceIds ) )")})
@SequenceGenerator(name="RHQ_ALERT_NOTIF_LOG_ID_SEQ", sequenceName="RHQ_ALERT_NOTIF_LOG_ID_SEQ")
@Table(name="RHQ_ALERT_NOTIF_LOG")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AlertNotificationLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_DELETE_BY_RESOURCE = "AlertNotificationLog.deleteByResource";
    public static final String QUERY_DELETE_BY_ALERT_CTIME = "AlertNotificationLog.deleteByAlertCtime";
    public static final String QUERY_DELETE_BY_RESOURCES = "AlertNotificationLog.deleteByResources";
    public static final String QUERY_NATIVE_TRUNCATE_SQL = "TRUNCATE TABLE RHQ_ALERT_NOTIF_LOG";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_ALERT_NOTIF_LOG_ID_SEQ")
    @Id
    private int id;
    @JoinColumn(name="ALERT_ID", referencedColumnName="ID")
    @ManyToOne
    @XmlTransient
    private Alert alert;
    private String sender;
    @Column(name="RESULT_STATE")
    @Enumerated(value=EnumType.STRING)
    private ResultState resultState;
    private String message;
    @Column(name="ALL_EMAILS")
    private String allEmails;
    @Column(name="EMAILS_FAILED")
    private String badEmails;
    @Transient
    transient List<String> transientEmails = new ArrayList<String>();

    @PrePersist
    @PreUpdate
    public void trimMessage() {
        if (this.message != null && this.message.length() > 255) {
            this.message = this.message.substring(0, 255);
        }
    }

    protected AlertNotificationLog() {
    }

    public AlertNotificationLog(Alert alert, String sender, SenderResult senderResult) {
        this.alert = alert;
        this.sender = sender;
        this.resultState = senderResult.getState();
        this.message = senderResult.getMessage();
        if (this.resultState == ResultState.DEFERRED_EMAIL && senderResult.getEmails() != null) {
            this.transientEmails.addAll(senderResult.getEmails());
            this.allEmails = StringUtils.getListAsString(senderResult.getEmails(), ",");
        }
    }

    public AlertNotificationLog(Alert alert, String sender) {
        this.alert = alert;
        this.sender = sender;
        this.resultState = ResultState.FAILURE;
    }

    public AlertNotificationLog(Alert alert, String senderName, ResultState state, String message) {
        this.alert = alert;
        this.resultState = state;
        this.message = message;
    }

    public int getId() {
        return this.id;
    }

    public Alert getAlert() {
        return this.alert;
    }

    public void setAlert(Alert alert) {
        this.alert = alert;
    }

    public String getSender() {
        return this.sender;
    }

    public ResultState getResultState() {
        return this.resultState;
    }

    public String getMessage() {
        return this.message;
    }

    public String getAllEmails() {
        return this.allEmails;
    }

    public String getBadEmails() {
        return this.badEmails;
    }

    public void setResultState(ResultState resultState) {
        this.resultState = resultState;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setAllEmails(String allEmails) {
        this.allEmails = allEmails;
    }

    public void setBadEmails(String badEmails) {
        this.badEmails = badEmails;
    }

    public List<String> getTransientEmails() {
        return this.transientEmails;
    }

    public void setTransientEmails(List<String> transientEmails) {
        this.transientEmails = transientEmails;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AlertNotificationLog");
        sb.append("{id=").append(this.id);
        sb.append(", alert=").append(this.alert);
        sb.append(", sender='").append(this.sender).append('\'');
        sb.append(", resultState=").append((Object)this.resultState);
        sb.append(", message='").append(this.message).append('\'');
        sb.append(", allEmails='").append(this.allEmails).append('\'');
        sb.append(", badEmails='").append(this.badEmails).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

