/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.bundle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.content.Repo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="Bundle.findAll", query="SELECT b FROM Bundle b"), @NamedQuery(name="Bundle.findByName", query="SELECT b FROM Bundle b WHERE :name = b.name"), @NamedQuery(name="Bundle.findByTypeAndName", query="SELECT b FROM Bundle b WHERE (:type = b.bundleType.name OR :type IS NULL) AND (:name = b.name OR :name IS NULL)")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_BUNDLE_ID_SEQ")
@Table(name="RHQ_BUNDLE")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Bundle
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "Bundle.findAll";
    public static final String QUERY_FIND_BY_NAME = "Bundle.findByName";
    public static final String QUERY_FIND_BY_TYPE_AND_NAME = "Bundle.findByTypeAndName";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @JoinColumn(name="BUNDLE_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private BundleType bundleType;
    @JoinColumn(name="REPO_ID", referencedColumnName="ID", nullable=false)
    @OneToOne(fetch=FetchType.LAZY, optional=false, cascade={CascadeType.ALL})
    private Repo repo;
    @OneToMany(mappedBy="bundle", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<BundleVersion> bundleVersions = new ArrayList<BundleVersion>();

    public Bundle() {
    }

    public Bundle(String name, BundleType type) {
        this.setName(name);
        this.setBundleType(type);
        Repo repo = new Repo(name);
        repo.setCandidate(false);
        repo.setSyncSchedule(null);
        this.setRepo(repo);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BundleType getBundleType() {
        return this.bundleType;
    }

    public void setBundleType(BundleType bundleType) {
        this.bundleType = bundleType;
    }

    public Repo getRepo() {
        return this.repo;
    }

    public void setRepo(Repo repo) {
        this.repo = repo;
    }

    public List<BundleVersion> getBundleVersions() {
        return this.bundleVersions;
    }

    public void addBundleVersion(BundleVersion bundleVersion) {
        this.bundleVersions.add(bundleVersion);
        bundleVersion.setBundle(this);
    }

    public void setBundleVersions(List<BundleVersion> bundleVersions) {
        this.bundleVersions = bundleVersions;
    }

    public String toString() {
        return "Bundle[id=" + this.id + ",name=" + this.name + ",bundleType=" + this.bundleType + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Bundle)) {
            return false;
        }
        Bundle other = (Bundle)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

