/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.bundle;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.bundle.BundleDeployment;

@Entity
@SequenceGenerator(name="SEQ", sequenceName="RHQ_BUNDLE_DEPLOY_HIST_ID_SEQ")
@Table(name="RHQ_BUNDLE_DEPLOY_HIST")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BundleDeploymentHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="BUNDLE_DEPLOY_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private BundleDeployment bundleDeployment;
    @Column(name="SUBJECT_NAME", nullable=true)
    protected String subjectName;
    @Column(name="AUDIT_TIME", nullable=false)
    private Long auditTime = System.currentTimeMillis();
    @Column(name="AUDIT_ACTION", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private BundleDeploymentHistory auditAction;
    @Column(name="AUDIT_MESSAGE", nullable=true)
    private String auditMessage;

    protected BundleDeploymentHistory() {
    }

    public BundleDeploymentHistory(BundleDeployment bundleDeployment, String subjectName, Long auditTime, BundleDeploymentHistory auditAction, String auditMessage) {
        this.bundleDeployment = bundleDeployment;
        this.subjectName = subjectName;
        this.auditTime = auditTime;
        this.auditAction = auditAction;
        this.auditMessage = auditMessage;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public BundleDeployment getBundleDeployment() {
        return this.bundleDeployment;
    }

    public void setBundleDeployment(BundleDeployment bundleDeployment) {
        this.bundleDeployment = bundleDeployment;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getAuditTime() {
        return this.auditTime;
    }

    public void setAuditTime(Long auditTime) {
        this.auditTime = auditTime;
    }

    public BundleDeploymentHistory getAuditAction() {
        return this.auditAction;
    }

    public void setAuditAction(BundleDeploymentHistory auditAction) {
        this.auditAction = auditAction;
    }

    public String getAuditMessage() {
        return this.auditMessage;
    }

    public void setAuditMessage(String auditMessage) {
        this.auditMessage = auditMessage;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("BundleDeploymentAudit: ");
        str.append(", time=[").append(this.auditTime).append("]");
        str.append(", bd=[").append(this.bundleDeployment).append("]");
        str.append(", action=[").append(this.auditAction).append("]");
        str.append(", message=[").append(this.auditMessage).append("]");
        return str.toString();
    }
}

