/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.bundle;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.resource.ResourceType;

@Entity
@NamedQueries(value={@NamedQuery(name="BundleType.findAll", query="SELECT bt FROM BundleType bt"), @NamedQuery(name="BundleType.findByName", query="SELECT bt FROM BundleType bt WHERE bt.name = :name")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_BUNDLE_TYPE_ID_SEQ")
@Table(name="RHQ_BUNDLE_TYPE")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BundleType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "BundleType.findAll";
    public static final String QUERY_FIND_BY_NAME = "BundleType.findByName";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @JoinColumn(name="RESOURCE_TYPE_ID", referencedColumnName="ID", nullable=false)
    @OneToOne(fetch=FetchType.LAZY, optional=false)
    private ResourceType resourceType;

    public BundleType() {
    }

    public BundleType(String name, ResourceType resourceType) {
        this.setName(name);
        this.setResourceType(resourceType);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.resourceType.setBundleType(this);
    }

    public String toString() {
        return "BundleType[id=" + this.id + ",name=" + this.name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BundleType)) {
            return false;
        }
        BundleType other = (BundleType)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

