/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.bundle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployDefinition;
import org.rhq.core.domain.bundle.BundleFile;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.Distribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="BundleVersion.findAll", query="SELECT bv FROM BundleVersion bv"), @NamedQuery(name="BundleVersion.findByName", query="SELECT bv FROM BundleVersion bv WHERE bv.name = :name")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_BUNDLE_VERSION_ID_SEQ")
@Table(name="RHQ_BUNDLE_VERSION")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BundleVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "BundleVersion.findAll";
    public static final String QUERY_FIND_BY_NAME = "BundleVersion.findByName";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="VERSION", nullable=false)
    private String version;
    @Column(name="ACTION", nullable=false)
    private String recipe;
    @JoinColumn(name="BUNDLE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Bundle bundle;
    @JoinColumn(name="DISTRIBUTION_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne(fetch=FetchType.LAZY)
    private Distribution distribution;
    @JoinColumn(name="CONFIG_DEF_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private ConfigurationDefinition configurationDefinition;
    @OneToMany(mappedBy="bundleVersion", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<BundleDeployDefinition> bundleDeployDefinitions = new ArrayList<BundleDeployDefinition>();
    @OneToMany(mappedBy="bundleVersion", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<BundleFile> bundleFiles = new ArrayList<BundleFile>();

    public BundleVersion() {
    }

    public BundleVersion(String name, String version, Bundle bundle, String recipe) {
        this.setName(name);
        this.setVersion(version);
        this.setBundle(bundle);
        this.setRecipe(recipe);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRecipe() {
        return this.recipe;
    }

    public void setRecipe(String recipe) {
        this.recipe = recipe;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
    }

    public ConfigurationDefinition getConfigurationDefinition() {
        return this.configurationDefinition;
    }

    public void setConfigurationDefinition(ConfigurationDefinition configurationDefinition) {
        this.configurationDefinition = configurationDefinition;
    }

    public List<BundleDeployDefinition> getBundleDeployDefinitions() {
        return this.bundleDeployDefinitions;
    }

    public void addBundleDeployDefinition(BundleDeployDefinition bundleDeployDefinition) {
        this.bundleDeployDefinitions.add(bundleDeployDefinition);
        bundleDeployDefinition.setBundleVersion(this);
    }

    public void setBundleDeployDefinitions(List<BundleDeployDefinition> bundleDeployDefinitions) {
        this.bundleDeployDefinitions = bundleDeployDefinitions;
    }

    public List<BundleFile> getBundleFiles() {
        return this.bundleFiles;
    }

    public void addBundleFile(BundleFile bundleFile) {
        this.bundleFiles.add(bundleFile);
        bundleFile.setBundleVersion(this);
    }

    public void setBundleFiles(List<BundleFile> bundleFiles) {
        this.bundleFiles = bundleFiles;
    }

    public String toString() {
        return "BundleVersion[id=" + this.id + ",name=" + this.name + ",version=" + this.version + ",bundle=" + this.bundle + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BundleVersion)) {
            return false;
        }
        BundleVersion other = (BundleVersion)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

