/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.cloud;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.cloud.FailoverList;
import org.rhq.core.domain.cloud.PartitionEventDetails;
import org.rhq.core.domain.cloud.PartitionEventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="PartitionEvent")
@NamedQueries(value={@NamedQuery(name="PartitionEvent.findAll", query="SELECT pe   FROM PartitionEvent pe WHERE (:type = pe.eventType OR :type is null)    AND (:status = pe.executionStatus OR :status is null)   AND (UPPER(pe.eventDetail) LIKE :details ESCAPE :escapeChar OR :details is null) "), @NamedQuery(name="PartitionEvent.findByExecutionStatus", query="SELECT pe FROM PartitionEvent pe WHERE pe.executionStatus = :executionStatus")})
@SequenceGenerator(name="id", sequenceName="RHQ_PARTITION_EVENT_ID_SEQ")
@Table(name="RHQ_PARTITION_EVENT")
public class PartitionEvent
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "PartitionEvent.findAll";
    public static final String QUERY_FIND_BY_EXECUTION_STATUS = "PartitionEvent.findByExecutionStatus";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="id")
    @Id
    private int id;
    @Column(name="SUBJECT_NAME")
    protected String subjectName;
    @Column(name="CTIME", nullable=false)
    private long ctime;
    @Column(name="EVENT_TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private PartitionEventType eventType;
    @Column(name="EVENT_DETAIL", nullable=true)
    private String eventDetail;
    @Column(name="EXECUTION_STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ExecutionStatus executionStatus;
    @OneToMany(mappedBy="partitionEvent", cascade={CascadeType.ALL})
    private List<PartitionEventDetails> partitionDetails = new ArrayList<PartitionEventDetails>();
    @OneToMany(mappedBy="partitionEvent", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<FailoverList> serverLists = new ArrayList<FailoverList>();

    protected PartitionEvent() {
    }

    public PartitionEvent(String subjectName, PartitionEventType eventType, ExecutionStatus executionStatus) {
        this(subjectName, eventType, null, executionStatus);
    }

    public PartitionEvent(String subjectName, PartitionEventType eventType, String eventDetail, ExecutionStatus executionStatus) {
        this.subjectName = subjectName;
        this.eventType = eventType;
        this.eventDetail = eventDetail;
        this.executionStatus = executionStatus;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public PartitionEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(PartitionEventType eventType) {
        this.eventType = eventType;
    }

    public String getEventDetail() {
        return this.eventDetail;
    }

    public void setEventDetail(String eventDetail) {
        this.eventDetail = eventDetail;
    }

    public List<PartitionEventDetails> getPartitionDetails() {
        return this.partitionDetails;
    }

    public void setPartitionDetails(List<PartitionEventDetails> partitionDetails) {
        this.partitionDetails = partitionDetails;
    }

    public List<FailoverList> getServerLists() {
        return this.serverLists;
    }

    public void setServerLists(List<FailoverList> serverLists) {
        this.serverLists = serverLists;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    @PrePersist
    void onPersist() {
        this.ctime = System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.ctime ^ this.ctime >>> 32);
        result = 31 * result + (this.subjectName == null ? 0 : this.subjectName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PartitionEvent)) {
            return false;
        }
        PartitionEvent other = (PartitionEvent)obj;
        if (this.ctime != other.ctime) {
            return false;
        }
        return !(this.subjectName == null ? other.subjectName != null : !this.subjectName.equals(other.subjectName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExecutionStatus {
        AUDIT("This parition event is executed only as an audit activity and did not affect server list generation"),
        COMPLETED("The request for this partition event has been completed by the cloud manager job"),
        IMMEDIATE("This partition event was executed at creation time."),
        REQUESTED("This partition event has been requested of the cloud manager job.");

        public final String message;

        private ExecutionStatus(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

