/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.cloud.composite;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverListComposite
implements Iterator<ServerEntry>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<ServerEntry> servers;
    private int nextIndex = 0;

    public FailoverListComposite(List<ServerEntry> servers) {
        this.servers = Collections.unmodifiableList(new ArrayList<ServerEntry>(servers));
    }

    public int size() {
        if (this.servers == null) {
            return 0;
        }
        return this.servers.size();
    }

    @Override
    public boolean hasNext() {
        return this.servers != null && this.servers.size() > 0;
    }

    @Override
    public ServerEntry next() {
        if (!this.hasNext()) {
            return null;
        }
        ServerEntry nextOne = this.servers.get(this.nextIndex);
        ++this.nextIndex;
        this.nextIndex %= this.servers.size();
        return nextOne;
    }

    public ServerEntry peek() {
        if (!this.hasNext()) {
            return null;
        }
        ServerEntry nextOne = this.servers.get(this.nextIndex);
        return nextOne;
    }

    public ServerEntry get(int index) {
        return this.servers.get(index);
    }

    public void resetIndex() {
        this.nextIndex = 0;
    }

    @Override
    public void remove() {
        throw new IllegalAccessError(this.getClass().getSimpleName() + " are immutable lists, removal is disallowed");
    }

    public void print(PrintWriter writer) {
        for (int i = 0; i < this.size(); ++i) {
            writer.println(this.servers.get(i) + (i == this.nextIndex ? " (next)" : ""));
        }
    }

    public String writeAsText() {
        StringBuilder text = new StringBuilder();
        for (ServerEntry entry : this.servers) {
            if (text.length() > 0) {
                text.append("\n");
            }
            text.append(entry);
        }
        return text.toString();
    }

    public static FailoverListComposite readAsText(String text) {
        ArrayList<ServerEntry> servers = new ArrayList<ServerEntry>();
        StringTokenizer rowTokenizer = new StringTokenizer(text, "\n");
        while (rowTokenizer.hasMoreTokens()) {
            try {
                String row = rowTokenizer.nextToken();
                String[] addressPorts = row.split(":");
                String[] ports = addressPorts[1].split("/");
                servers.add(new ServerEntry(addressPorts[0], Integer.parseInt(ports[0]), Integer.parseInt(ports[1])));
            }
            catch (Exception exception) {}
        }
        return new FailoverListComposite(servers);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size());
        for (ServerEntry entry : this.servers) {
            out.writeUTF(entry.address);
            out.writeInt(entry.port);
            out.writeInt(entry.securePort);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<ServerEntry> entries = new ArrayList<ServerEntry>();
        for (int i = 0; i < size; ++i) {
            String address = in.readUTF();
            int port = in.readInt();
            int securePort = in.readInt();
            entries.add(new ServerEntry(address, port, securePort));
        }
        this.servers = Collections.unmodifiableList(entries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\nServerList:\n  ");
        for (ServerEntry server : this.servers) {
            sb.append(server.toString());
            sb.append("\n  ");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FailoverListComposite)) {
            return false;
        }
        FailoverListComposite flc = (FailoverListComposite)obj;
        return ((Object)this.servers).equals(flc.servers);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.servers == null ? 0 : ((Object)this.servers).hashCode());
        return result;
    }

    public static class ServerEntry {
        public final int serverId;
        public final String address;
        public final int port;
        public final int securePort;

        public ServerEntry(String address, int port, int securePort) {
            this(-1, address, port, securePort);
        }

        public ServerEntry(int serverId, String address, int port, int securePort) {
            this.serverId = serverId;
            this.address = address;
            this.port = port;
            this.securePort = securePort;
        }

        public String toString() {
            return this.address + ":" + this.port + "/" + this.securePort;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ServerEntry)) {
                return false;
            }
            ServerEntry se = (ServerEntry)obj;
            return this.address.equals(se.address) && this.port == se.port && this.securePort == se.securePort;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.port;
            result = 31 * result + this.securePort;
            result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
            return result;
        }
    }
}

