/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;

@MappedSuperclass
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractConfigurationUpdate
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="CONFIGURATION_ID", referencedColumnName="ID", nullable=false)
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @XmlTransient
    protected Configuration configuration;
    @Column(name="STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    protected ConfigurationUpdateStatus status;
    @Column(name="ERROR_MESSAGE")
    protected String errorMessage;
    @Column(name="SUBJECT_NAME")
    protected String subjectName;
    @Column(name="CTIME", nullable=false)
    protected long createdTime = System.currentTimeMillis();
    @Column(name="MTIME", nullable=false)
    protected long modifiedTime = System.currentTimeMillis();

    protected AbstractConfigurationUpdate() {
    }

    protected AbstractConfigurationUpdate(String subjectName) {
        this.subjectName = subjectName;
        this.status = ConfigurationUpdateStatus.INPROGRESS;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public ConfigurationUpdateStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConfigurationUpdateStatus status) {
        if (status == null) {
            throw new NullPointerException("status==null");
        }
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessage != null) {
            this.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    public void setErrorMessageFromThrowable(Throwable t) {
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            this.setErrorMessage(baos.toString());
        } else {
            this.setErrorMessage(null);
        }
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public long getModifiedTime() {
        return this.modifiedTime;
    }

    public long getDuration() {
        long start = this.createdTime;
        long end = this.status == null || this.status == ConfigurationUpdateStatus.INPROGRESS ? System.currentTimeMillis() : this.modifiedTime;
        return end - start;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.createdTime ^ this.createdTime >>> 32);
        result = 31 * result + (this.subjectName == null ? 0 : this.subjectName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractConfigurationUpdate)) {
            return false;
        }
        AbstractConfigurationUpdate other = (AbstractConfigurationUpdate)obj;
        if (this.createdTime != other.createdTime) {
            return false;
        }
        return !(this.subjectName == null ? other.subjectName != null : !this.subjectName.equals(other.subjectName));
    }

    @PrePersist
    void onPersist() {
        this.modifiedTime = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.modifiedTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName());
        str.append("[status=").append((Object)this.status);
        str.append(", configuration=").append(this.configuration);
        str.append(", subjectName=").append(this.subjectName);
        str.append(", createdTime=").append(this.createdTime);
        str.append(", modifiedTime=").append(this.modifiedTime);
        String err = this.errorMessage;
        if (err != null && err.indexOf(10) > -1) {
            err = err.substring(0, err.indexOf(10)) + "...";
        }
        str.append(", errorMessage=").append(err);
        this.appendToStringInternals(str);
        str.append(']');
        return str.toString();
    }

    protected void appendToStringInternals(StringBuilder str) {
    }
}

