/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.InstalledPackageHistory;
import org.rhq.core.domain.content.transfer.ContentResponseResult;

@Entity
@NamedQueries(value={@NamedQuery(name="PackageInstallationStep.deleteByResources", query="DELETE PackageInstallationStep pis WHERE pis.installedPackageHistory IN ( SELECT iph FROM InstalledPackageHistory iph WHERE iph.resource.id IN ( :resourceIds ) )"), @NamedQuery(name="PackageInstallationStep.findByInstalledPackageHistoryId", query="SELECT pis FROM PackageInstallationStep pis WHERE pis.installedPackageHistory.id = :installedPackageHistoryId")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_PACKAGE_INST_STEP_ID_SEQ")
@Table(name="RHQ_PACKAGE_INST_STEP")
public class PackageInstallationStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_DELETE_BY_RESOURCES = "PackageInstallationStep.deleteByResources";
    public static final String QUERY_FIND_BY_INSTALLED_PACKAGE_HISTORY_ID = "PackageInstallationStep.findByInstalledPackageHistoryId";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="STEP_KEY", nullable=false)
    private String key;
    @Column(name="STEP_ORDER", nullable=false)
    private int order;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="ERROR_MSG")
    private String errorMessage;
    @Column(name="RESULT", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ContentResponseResult result;
    @JoinColumn(name="INSTALLED_PKG_HIST_ID", referencedColumnName="ID")
    @ManyToOne
    private InstalledPackageHistory installedPackageHistory;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ContentResponseResult getResult() {
        return this.result;
    }

    public void setResult(ContentResponseResult result) {
        this.result = result;
    }

    public InstalledPackageHistory getInstalledPackageHistory() {
        return this.installedPackageHistory;
    }

    public void setInstalledPackageHistory(InstalledPackageHistory installedPackageHistory) {
        this.installedPackageHistory = installedPackageHistory;
    }
}

