/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.rhq.core.domain.content.Advisory;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoAdvisoryPK;

@Entity
@IdClass(value=RepoAdvisoryPK.class)
@NamedQueries(value={@NamedQuery(name="RepoAdvisory.deleteByAdvisoryId", query="DELETE RepoAdvisory rkt WHERE rkt.advisory.id = :advId"), @NamedQuery(name="RepoAdvisory.deleteByRepoId", query="DELETE RepoAdvisory rkt WHERE rkt.repo.id = :repoId"), @NamedQuery(name="RepoAdvisory.queryFindByRepoId", query="SELECT rkt FROM RepoAdvisory rkt where rkt.repo.id = :repoId ")})
@Table(name="RHQ_REPO_ADVISORY")
public class RepoAdvisory
implements Serializable {
    public static final String DELETE_BY_ADVISORY_ID = "RepoAdvisory.deleteByAdvisoryId";
    public static final String DELETE_BY_REPO_ID = "RepoAdvisory.deleteByRepoId";
    public static final String QUERY_FIND_BY_REPO_ID = "RepoAdvisory.queryFindByRepoId";
    private static final long serialVersionUID = 1L;
    @Id
    @ManyToOne
    @JoinColumn(name="REPO_ID", referencedColumnName="ID", nullable=false, insertable=false, updatable=false)
    private Repo repo;
    @Id
    @ManyToOne
    @JoinColumn(name="ADVISORY_ID", referencedColumnName="ID", nullable=false, insertable=false, updatable=false)
    private Advisory advisory;
    @Column(name="LAST_MODIFIED", nullable=false)
    private long last_modified;

    protected RepoAdvisory() {
    }

    public RepoAdvisory(Repo repo, Advisory advisory) {
        this.repo = repo;
        this.advisory = advisory;
    }

    public RepoAdvisoryPK getRepoAdvisoryPK() {
        return new RepoAdvisoryPK(this.repo, this.advisory);
    }

    public void setRepoAdvisoryPK(RepoAdvisoryPK pk) {
        this.repo = pk.getRepo();
        this.advisory = pk.getAdvisory();
    }

    public long getLastModified() {
        return this.last_modified;
    }

    public Repo getRepo() {
        return this.repo;
    }

    public void setRepo(Repo repo) {
        this.repo = repo;
    }

    public Advisory getAdvisory() {
        return this.advisory;
    }

    public void setAdvisory(Advisory advisory) {
        this.advisory = advisory;
    }

    @PrePersist
    void onPersist() {
        this.last_modified = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("RepoAdvisory: ");
        str.append("ctime=[").append(new Date(this.last_modified)).append("]");
        str.append(", Repo=[").append(this.repo).append("]");
        str.append(", Advisory=[").append(this.advisory).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        result = 31 * result + (this.advisory == null ? 0 : this.advisory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepoAdvisory)) {
            return false;
        }
        RepoAdvisory other = (RepoAdvisory)obj;
        if (this.repo == null ? this.repo != null : !this.repo.equals(other.repo)) {
            return false;
        }
        return !(this.advisory == null ? this.advisory != null : !this.advisory.equals(other.advisory));
    }
}

