/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoGroupType;
import org.rhq.core.domain.content.RepoRepoGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="RepoGroup.findByName", query="SELECT g FROM RepoGroup g WHERE g.name = :name")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_REPO_GROUP_ID_SEQ")
@Table(name="RHQ_REPO_GROUP")
public class RepoGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_NAME = "RepoGroup.findByName";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @JoinColumn(name="REPO_GROUP_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private RepoGroupType repoGroupType;
    @OneToMany(mappedBy="repoGroup", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<RepoRepoGroup> repoRepoGroups;

    public RepoGroup() {
    }

    public RepoGroup(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RepoGroupType getRepoGroupType() {
        return this.repoGroupType;
    }

    public void setRepoGroupType(RepoGroupType repoGroupType) {
        this.repoGroupType = repoGroupType;
    }

    public Set<RepoRepoGroup> getRepoRepoGroups() {
        return this.repoRepoGroups;
    }

    public Set<Repo> getRepos() {
        HashSet<Repo> repos = new HashSet<Repo>();
        if (this.repoRepoGroups != null) {
            for (RepoRepoGroup ccs : this.repoRepoGroups) {
                repos.add(ccs.getRepoRepoGroupPK().getRepo());
            }
        }
        return repos;
    }

    public RepoRepoGroup addRepo(Repo repo) {
        if (this.repoRepoGroups == null) {
            this.repoRepoGroups = new HashSet<RepoRepoGroup>();
        }
        RepoRepoGroup mapping = new RepoRepoGroup(repo, this);
        this.repoRepoGroups.add(mapping);
        repo.addRepoGroup(this);
        return mapping;
    }

    public RepoRepoGroup removeRepo(Repo repo) {
        if (this.repoRepoGroups == null || repo == null) {
            return null;
        }
        RepoRepoGroup doomed = null;
        for (RepoRepoGroup rrg : this.repoRepoGroups) {
            if (!repo.equals(rrg.getRepoRepoGroupPK().getRepo())) continue;
            doomed = rrg;
            repo.removeRepoGroup(this);
            break;
        }
        if (doomed != null) {
            this.repoRepoGroups.remove(doomed);
        }
        return doomed;
    }

    public String toString() {
        return "RepoGroup: id=[" + this.id + "], name=[" + this.name + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepoGroup)) {
            return false;
        }
        RepoGroup other = (RepoGroup)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

