/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoRelationshipType;
import org.rhq.core.domain.content.RepoRepoRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="RepoRelationship.deleteByRelatedRepoId", query="DELETE RepoRelationship rr WHERE rr.relatedRepo.id = :relatedRepoId")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_REPO_RELATION_ID_SEQ")
@Table(name="RHQ_REPO_RELATION")
public class RepoRelationship
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DELETE_BY_RELATED_REPO_ID = "RepoRelationship.deleteByRelatedRepoId";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="RELATED_REPO_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private Repo relatedRepo;
    @JoinColumn(name="REPO_RELATION_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private RepoRelationshipType repoRelationshipType;
    @OneToMany(mappedBy="repoRelationship", fetch=FetchType.LAZY)
    private Set<RepoRepoRelationship> repoRepoRelationships;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Repo getRelatedRepo() {
        return this.relatedRepo;
    }

    public void setRelatedRepo(Repo relatedRepo) {
        this.relatedRepo = relatedRepo;
    }

    public RepoRelationshipType getRepoRelationshipType() {
        return this.repoRelationshipType;
    }

    public void setRepoRelationshipType(RepoRelationshipType repoRelationshipType) {
        this.repoRelationshipType = repoRelationshipType;
    }

    public Set<RepoRepoRelationship> getRepoRepoRelationships() {
        return this.repoRepoRelationships;
    }

    public Set<Repo> getRelatedRepos() {
        HashSet<Repo> repos = new HashSet<Repo>();
        if (this.repoRepoRelationships != null) {
            for (RepoRepoRelationship rrr : this.repoRepoRelationships) {
                repos.add(rrr.getRepoRepoRelationshipPK().getRepo());
            }
        }
        return repos;
    }

    public RepoRepoRelationship addRepo(Repo repo) {
        if (this.repoRepoRelationships == null) {
            this.repoRepoRelationships = new HashSet<RepoRepoRelationship>();
        }
        RepoRepoRelationship mapping = new RepoRepoRelationship(repo, this);
        this.repoRepoRelationships.add(mapping);
        return mapping;
    }

    public RepoRepoRelationship removeRepo(Repo repo) {
        if (this.repoRepoRelationships == null || repo == null) {
            return null;
        }
        RepoRepoRelationship doomed = null;
        for (RepoRepoRelationship rrr : this.repoRepoRelationships) {
            if (!repo.equals(rrr.getRepoRepoRelationshipPK().getRepo())) continue;
            doomed = rrr;
            break;
        }
        if (doomed != null) {
            this.repoRepoRelationships.remove(doomed);
        }
        return doomed;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.relatedRepo == null ? 0 : this.relatedRepo.hashCode());
        result = 31 * result + (this.repoRelationshipType == null ? 0 : this.repoRelationshipType.hashCode());
        return result;
    }

    public String toString() {
        return "RepoRelationship: id=[" + this.id + "]" + "related repo=[" + this.relatedRepo.getName() + "]" + "relation=[" + this.getRepoRelationshipType().getName() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepoRelationship)) {
            return false;
        }
        RepoRelationship other = (RepoRelationship)obj;
        if (this.relatedRepo.getName() == null ? other.relatedRepo.getName() != null : !this.relatedRepo.getName().equals(other.relatedRepo.getName())) {
            return false;
        }
        return !(this.repoRelationshipType.getName() == null ? other.repoRelationshipType.getName() != null : !this.repoRelationshipType.getName().equals(other.relatedRepo.getName()));
    }
}

