/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoGroup;
import org.rhq.core.domain.content.RepoRepoGroupPK;

@Entity
@IdClass(value=RepoRepoGroupPK.class)
@Table(name="RHQ_REPO_REPO_GRP_MAP")
public class RepoRepoGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @ManyToOne
    @JoinColumn(name="REPO_ID", referencedColumnName="ID", nullable=false, insertable=false, updatable=false)
    private Repo repo;
    @Id
    @ManyToOne
    @JoinColumn(name="REPO_GRP_ID", referencedColumnName="ID", nullable=false, insertable=false, updatable=false)
    private RepoGroup repoGroup;
    @Column(name="CTIME", nullable=false)
    private long createdTime;

    protected RepoRepoGroup() {
    }

    public RepoRepoGroup(Repo repo, RepoGroup repoGroup) {
        this.repo = repo;
        this.repoGroup = repoGroup;
    }

    public RepoRepoGroupPK getRepoRepoGroupPK() {
        return new RepoRepoGroupPK(this.repo, this.repoGroup);
    }

    public void setRepoRepoGroupPK(RepoRepoGroupPK pk) {
        this.repo = pk.getRepo();
        this.repoGroup = pk.getRepoGroup();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    @PrePersist
    void onPersist() {
        this.createdTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("RepoRepoGroup: ");
        str.append("ctime=[").append(new Date(this.createdTime)).append("]");
        str.append(", rp=[").append(this.repo).append("]");
        str.append(", rg=[").append(this.repoGroup).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        result = 31 * result + (this.repoGroup == null ? 0 : this.repoGroup.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepoRepoGroup)) {
            return false;
        }
        RepoRepoGroup other = (RepoRepoGroup)obj;
        if (this.repo == null ? this.repo != null : !this.repo.equals(other.repo)) {
            return false;
        }
        return !(this.repoGroup == null ? this.repoGroup != null : !this.repoGroup.equals(other.repoGroup));
    }
}

