/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.criteria;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.util.PageOrdering;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class EventCriteria
extends Criteria {
    private static final long serialVersionUID = 1L;
    private Integer filterId;
    private String filterDetail;
    private String filterSourceName;
    private EventSeverity filterSeverity;
    private Long filterStartTime;
    private Long filterEndTime;
    private Integer filterResourceId;
    private Integer filterResourceGroupId;
    private Integer filterAutoGroupResourceTypeId;
    private Integer filterAutoGroupParentResourceId;
    private boolean fetchSource;
    private PageOrdering sortTimestamp;
    private PageOrdering sortSeverity;

    public EventCriteria() {
        super(Event.class);
        this.filterOverrides.put("sourceName", "source.eventDefinition.name like ?");
        this.filterOverrides.put("startTime", "timestamp >= ?");
        this.filterOverrides.put("endTime", "timestamp <= ?");
        this.filterOverrides.put("resourceId", "source.resourceId = ?");
        this.filterOverrides.put("resourceGroupId", "source.resourceId IN ( SELECT res.id     FROM Resource res     JOIN res.implicitGroups ig    WHERE ig.id = ? )");
        this.filterOverrides.put("autoGroupResourceTypeId", "source.resourceId IN ( SELECT res.id     FROM Resource res     JOIN res.resourceType type    WHERE type.id = ? )");
        this.filterOverrides.put("autoGroupParentResourceId", "source.resourceId IN ( SELECT res.id     FROM Resource res     JOIN res.parentResource parent    WHERE parent.id = ? )");
    }

    public void addFilterId(Integer filterId) {
        this.filterId = filterId;
    }

    public void addFilterDetail(String filterDetail) {
        this.filterDetail = filterDetail;
    }

    public void addFilterSourceName(String filterSourceName) {
        this.filterSourceName = filterSourceName;
    }

    public void addFilterStartTime(long filterStartTime) {
        this.filterStartTime = filterStartTime;
    }

    public void addFilterEndTime(long filterEndTime) {
        this.filterEndTime = filterEndTime;
    }

    public void addFilterSeverity(EventSeverity filterSeverity) {
        this.filterSeverity = filterSeverity;
    }

    public void addFilterResourceId(Integer filterResourceId) {
        this.filterResourceId = filterResourceId;
    }

    public void addFilterResourceGroupId(Integer filterResourceGroupId) {
        this.filterResourceGroupId = filterResourceGroupId;
    }

    public void addFilterAutoGroupResourceTypeId(Integer filterAutoGroupResourceTypeId) {
        this.filterAutoGroupResourceTypeId = filterAutoGroupResourceTypeId;
    }

    public void addFilterAutoGroupParentResourceId(Integer filterAutoGroupParentResourceId) {
        this.filterAutoGroupParentResourceId = filterAutoGroupParentResourceId;
    }

    public void fetchSource(boolean fetchSource) {
        this.fetchSource = fetchSource;
    }

    public void addSortTimestamp(PageOrdering sortTimestamp) {
        this.addSortField("timestamp");
        this.sortTimestamp = sortTimestamp;
    }

    public void addSortSeverity(PageOrdering sortSeverity) {
        this.addSortField("severity");
        this.sortSeverity = sortSeverity;
    }
}

