/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.criteria;

import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageOrdering;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResourceGroupCriteria
extends Criteria {
    private static final long serialVersionUID = 1L;
    private Integer filterId;
    private String filterName;
    private Boolean filterRecursive;
    private Integer filterResourceTypeId;
    private String filterResourceTypeName;
    private String filterPluginName;
    private GroupCategory filterGroupCategory;
    private List<Integer> filterExplicitResourceIds;
    private List<Integer> filterImplicitResourceIds;
    private boolean fetchExplicitResources;
    private boolean fetchImplicitResources;
    private boolean fetchOperationHistories;
    private boolean fetchConfigurationUpdates;
    private boolean fetchGroupDefinition;
    private boolean fetchResourceType;
    private boolean fetchRoles;
    private PageOrdering sortName;
    private PageOrdering sortResourceTypeName;

    public ResourceGroupCriteria() {
        super(ResourceGroup.class);
        this.filterOverrides.put("resourceTypeId", "resourceType.id = ?");
        this.filterOverrides.put("resourceTypeName", "resourceType.name like ?");
        this.filterOverrides.put("pluginName", "resourceType.plugin like ?");
        this.filterOverrides.put("explicitResourceIds", "id IN ( SELECT explicitGroup.id           FROM Resource res           JOIN res.explicitGroups explicitGroup          WHERE res.id IN ( ? ) )");
        this.filterOverrides.put("implicitResourceIds", "id IN ( SELECT implicitGroup.id           FROM Resource res           JOIN res.implicitGroups implicitGroup          WHERE res.id IN ( ? ) )");
        this.sortOverrides.put("resourceTypeName", "resourceType.name");
    }

    public void addFilterId(Integer filterId) {
        this.filterId = filterId;
    }

    public void addFilterName(String filterName) {
        this.filterName = filterName;
    }

    public void addFilterRecursive(Boolean filterRecursive) {
        this.filterRecursive = filterRecursive;
    }

    public void addFilterResourceTypeId(Integer filterResourceTypeId) {
        this.filterResourceTypeId = filterResourceTypeId;
    }

    public void addFilterResourceTypeName(String filterResourceTypeName) {
        this.filterResourceTypeName = filterResourceTypeName;
    }

    public void addFilterPluginName(String filterPluginName) {
        this.filterPluginName = filterPluginName;
    }

    public void addFilterGroupCategory(GroupCategory filterGroupCategory) {
        this.filterGroupCategory = filterGroupCategory;
    }

    public void addFilterExplicitResourceIds(Integer ... filterExplicitResourceIds) {
        this.filterExplicitResourceIds = Arrays.asList(filterExplicitResourceIds);
    }

    public void addFilterImplicitResourceIds(Integer ... filterImplicitResourceIds) {
        this.filterImplicitResourceIds = Arrays.asList(filterImplicitResourceIds);
    }

    public void fetchExplicitResources(boolean fetchExplicitResources) {
        this.fetchExplicitResources = fetchExplicitResources;
    }

    public void fetchImplicitResources(boolean fetchImplicitResources) {
        this.fetchImplicitResources = fetchImplicitResources;
    }

    public void fetchOperationHistories(boolean fetchOperationHistories) {
        this.fetchOperationHistories = fetchOperationHistories;
    }

    public void fetchConfigurationUpdates(boolean fetchConfigurationUpdates) {
        this.fetchConfigurationUpdates = fetchConfigurationUpdates;
    }

    public void fetchGroupDefinition(boolean fetchGroupDefinition) {
        this.fetchGroupDefinition = fetchGroupDefinition;
    }

    public void fetchResourceType(boolean fetchResourceType) {
        this.fetchResourceType = fetchResourceType;
    }

    public void fetchRoles(boolean fetchRoles) {
        this.fetchRoles = fetchRoles;
    }

    public void addSortName(PageOrdering sortName) {
        this.addSortField("name");
        this.sortName = sortName;
    }

    public void addSortResourceTypeName(PageOrdering sortResourceTypeName) {
        this.addSortField("resourceTypeName");
        this.sortResourceTypeName = sortResourceTypeName;
    }

    public boolean isSecurityManagerRequired() {
        return this.fetchRoles;
    }
}

