/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.discovery;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.util.serial.HibernateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="RHQ_RESOURCE")
public class ResourceSyncInfo
implements Externalizable {
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    @Column(name="UUID")
    private String uuid;
    @Column(name="MTIME")
    private long mtime;
    @Column(name="INVENTORY_STATUS")
    @Enumerated(value=EnumType.STRING)
    private InventoryStatus inventoryStatus;
    @JoinColumn(name="PARENT_RESOURCE_ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private ResourceSyncInfo parent;
    @OneToMany(mappedBy="parent", fetch=FetchType.EAGER)
    private Collection<ResourceSyncInfo> childSyncInfos;

    public int getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public long getMtime() {
        return this.mtime;
    }

    public InventoryStatus getInventoryStatus() {
        return this.inventoryStatus;
    }

    public Collection<ResourceSyncInfo> getChildSyncInfos() {
        return this.childSyncInfos;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeUTF(this.uuid);
        out.writeLong(this.mtime);
        out.writeInt(this.inventoryStatus.ordinal());
        out.writeObject(HibernateUtil.safeCollection(this.childSyncInfos));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.uuid = in.readUTF();
        this.mtime = in.readLong();
        this.inventoryStatus = InventoryStatus.values()[in.readInt()];
        this.childSyncInfos = (Set)in.readObject();
    }
}

