/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.resource.ResourceType;

@Entity
@NamedQueries(value={@NamedQuery(name="EventDefinition.findByResourceTypeId", query="SELECT ed   FROM EventDefinition ed  WHERE ed.resourceTypeId = :resourceTypeId ")})
@Table(name="RHQ_EVENT_DEF")
@SequenceGenerator(name="idGenerator", sequenceName="RHQ_EVENT_DEF_ID_SEQ", allocationSize=100)
public class EventDefinition
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "RHQ_EVENT_DEF";
    public static final String QUERY_EVENT_DEFINITIONS_BY_RESOURCE_TYPE_ID = "EventDefinition.findByResourceTypeId";
    @Id
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="idGenerator")
    private int id;
    @JoinColumn(name="RESOURCE_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private ResourceType resourceType;
    @Column(name="RESOURCE_TYPE_ID", insertable=false, updatable=false)
    private int resourceTypeId;
    @Column(name="NAME", length=100, nullable=false)
    private String name;
    @Column(name="DISPLAY_NAME", length=100)
    private String displayName;
    @Column(name="DESCRIPTION", length=1000)
    private String description;

    public EventDefinition() {
    }

    public EventDefinition(@NotNull ResourceType resourceType, @NotNull String name) {
        if (resourceType == null) {
            throw new IllegalArgumentException("resourceType parameter must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name parameter must not be null.");
        }
        this.resourceType = resourceType;
        this.resourceTypeId = this.resourceType.getId();
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public int getResourceTypeId() {
        return this.resourceTypeId;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof EventDefinition)) {
            return false;
        }
        EventDefinition that = (EventDefinition)obj;
        if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "id=" + this.id + ", " + "resourceType.name=" + (this.resourceType != null ? this.resourceType.getName() : "null") + ", " + "name=" + this.name + "]";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.resourceType);
        out.writeUTF(this.name);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.resourceType = (ResourceType)in.readObject();
        this.name = in.readUTF();
    }

    public void setResourceTypeId(int resourceTypeId) {
        this.resourceTypeId = resourceTypeId;
    }
}

