/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement.calltime;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.measurement.calltime.CallTimeDataKey;

@Entity
@NamedQueries(value={@NamedQuery(name="CallTimeDataValue.findCompositesForResource", query="SELECT new org.rhq.core.domain.measurement.calltime.CallTimeDataComposite(key.callDestination, MIN(value.minimum), MAX(value.maximum), SUM(value.total), SUM(value.count), SUM(value.total) / SUM(value.count)) FROM CallTimeDataValue value JOIN value.key key WHERE key.schedule.id = :scheduleId AND value.count != 0 AND value.minimum != -1 AND value.beginTime >= :beginTime AND value.endTime <= :endTime GROUP BY key.callDestination "), @NamedQuery(name="CallTimeDataValue.deleteByResources", query="DELETE CallTimeDataValue ctdv WHERE ctdv.key IN ( SELECT ctdk.id FROM CallTimeDataKey ctdk WHERE ctdk.schedule.resource.id IN ( :resourceIds ) )")})
@SequenceGenerator(name="idGenerator", sequenceName="RHQ_CALLTIME_DATA_VALUE_ID_SEQ")
@Table(name="RHQ_CALLTIME_DATA_VALUE")
public class CallTimeDataValue
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_COMPOSITES_FOR_RESOURCE = "CallTimeDataValue.findCompositesForResource";
    public static final String QUERY_DELETE_BY_RESOURCES = "CallTimeDataValue.deleteByResources";
    @GeneratedValue(strategy=GenerationType.AUTO, generator="idGenerator")
    @Id
    private int id;
    @JoinColumn(name="KEY_ID", nullable=false)
    @ManyToOne
    private CallTimeDataKey key;
    @Column(name="BEGIN_TIME", nullable=false)
    private long beginTime;
    @Column(name="END_TIME", nullable=false)
    private long endTime;
    @Column(name="MINIMUM", nullable=false)
    private double minimum = Double.NaN;
    @Column(name="MAXIMUM", nullable=false)
    private double maximum;
    @Column(name="TOTAL", nullable=false)
    private double total;
    @Column(name="COUNT", nullable=false)
    private long count;

    public CallTimeDataValue(Date beginTime, Date endTime) {
        this.beginTime = beginTime.getTime();
        this.endTime = endTime.getTime();
    }

    public CallTimeDataValue() {
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public CallTimeDataKey getKey() {
        return this.key;
    }

    public void setKey(@Nullable CallTimeDataKey key) {
        this.key = key;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void mergeCallTime(double callTime) {
        if (callTime < 0.0) {
            throw new IllegalArgumentException("Call time is a duration and so must be >= 0.");
        }
        ++this.count;
        this.total += callTime;
        if (callTime < this.minimum || Double.isNaN(this.minimum)) {
            this.minimum = callTime;
        }
        if (callTime > this.maximum) {
            this.maximum = callTime;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.beginTime);
        out.writeLong(this.endTime);
        out.writeDouble(this.minimum);
        out.writeDouble(this.maximum);
        out.writeDouble(this.total);
        out.writeLong(this.count);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.beginTime = in.readLong();
        this.endTime = in.readLong();
        this.minimum = in.readDouble();
        this.maximum = in.readDouble();
        this.total = in.readDouble();
        this.count = in.readLong();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "key=" + this.key + ", " + "beginTime=" + DateFormat.getInstance().format(this.beginTime) + ", " + "endTime=" + DateFormat.getInstance().format(this.endTime) + ", " + "minimum=" + this.minimum + ", " + "maximum=" + this.maximum + ", " + "total=" + this.total + ", " + "count=" + this.count + "]";
    }
}

