/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.operation;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.rhq.core.domain.operation.JobId;
import org.rhq.core.domain.operation.ScheduleJobId;

@DiscriminatorColumn(name="DTYPE")
@Entity
@IdClass(value=ScheduleJobId.class)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@NamedQueries(value={@NamedQuery(name="OperationScheduleEntity.findByJobId", query="SELECT s   FROM OperationScheduleEntity s  WHERE s.jobName = :jobName    AND s.jobGroup = :jobGroup "), @NamedQuery(name="OperationScheduleEntity.getScheduleResource_admin", query="SELECT DISTINCT new org.rhq.core.domain.operation.composite.ResourceOperationScheduleComposite(     ro.jobName,     ro.jobGroup,     '',     ro.nextFireTime,     ro.resource.id,     ro.resource.name,     ro.resource.resourceType.name)   FROM ResourceOperationScheduleEntity ro  WHERE ro.nextFireTime IS NOT NULL "), @NamedQuery(name="OperationScheduleEntity.getScheduleResource", query="SELECT DISTINCT new org.rhq.core.domain.operation.composite.ResourceOperationScheduleComposite(     ro.jobName,     ro.jobGroup,     '',     ro.nextFireTime,     ro.resource.id,     ro.resource.name,     ro.resource.resourceType.name)   FROM ResourceOperationScheduleEntity ro   JOIN ro.resource.implicitGroups g   JOIN g.roles r   JOIN r.subjects s  WHERE ro.nextFireTime IS NOT NULL    AND s = :subject "), @NamedQuery(name="OperationScheduleEntity.getScheduleGroup_admin", query="SELECT DISTINCT new org.rhq.core.domain.operation.composite.GroupOperationScheduleComposite(     go.jobName,     go.jobGroup,     '',     go.nextFireTime,     go.group.id,     go.group.name,     go.group.resourceType.name)   FROM GroupOperationScheduleEntity go  WHERE go.nextFireTime IS NOT NULL "), @NamedQuery(name="OperationScheduleEntity.getScheduleGroup", query="SELECT DISTINCT new org.rhq.core.domain.operation.composite.GroupOperationScheduleComposite(     go.jobName,     go.jobGroup,     '',     go.nextFireTime,     go.group.id,     go.group.name,     go.group.resourceType.name)   FROM GroupOperationScheduleEntity go   JOIN go.group g   JOIN g.roles r   JOIN r.subjects s  WHERE go.nextFireTime IS NOT NULL    AND s = :subject ")})
@Table(name="RHQ_OPERATION_SCHEDULE")
public abstract class OperationScheduleEntity
implements Serializable {
    public static final String QUERY_FIND_BY_JOB_ID = "OperationScheduleEntity.findByJobId";
    public static final String QUERY_GET_SCHEDULE_RESOURCE = "OperationScheduleEntity.getScheduleResource";
    public static final String QUERY_GET_SCHEDULE_RESOURCE_ADMIN = "OperationScheduleEntity.getScheduleResource_admin";
    public static final String QUERY_GET_SCHEDULE_GROUP = "OperationScheduleEntity.getScheduleGroup";
    public static final String QUERY_GET_SCHEDULE_GROUP_ADMIN = "OperationScheduleEntity.getScheduleGroup_admin";
    private static final long serialVersionUID = 1L;
    @Id
    private String jobName;
    @Id
    private String jobGroup;
    @Column(name="NEXT_FIRE_TIME", nullable=true)
    private Long nextFireTime;

    protected OperationScheduleEntity() {
    }

    protected OperationScheduleEntity(String jobName, String jobGroup, Date nextFireTime) {
        this.jobName = jobName;
        this.jobGroup = jobGroup;
        this.nextFireTime = nextFireTime == null ? null : Long.valueOf(nextFireTime.getTime());
    }

    public JobId getJobId() {
        return new ScheduleJobId(this.jobName, this.jobGroup);
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public Long setNextFireTime() {
        return this.nextFireTime;
    }

    public void setNextFireTime(Long nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("job-name=[" + this.jobName);
        buf.append("], job-group=[" + this.jobGroup);
        buf.append("], next-fire-time=[" + (this.nextFireTime == null ? "never" : new Date(this.nextFireTime)));
        return buf.toString();
    }

    public int hashCode() {
        return this.getJobId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OperationScheduleEntity)) {
            return false;
        }
        OperationScheduleEntity other = (OperationScheduleEntity)obj;
        return this.getJobId().equals(other.getJobId());
    }
}

