/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.operation;

import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.GroupOperationHistory;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.resource.Resource;

@DiscriminatorValue(value="resource")
@Entity
@NamedQueries(value={@NamedQuery(name="ResourceOperationHistory.findAllInStatus", query="SELECT h FROM ResourceOperationHistory h WHERE h.status = :status"), @NamedQuery(name="ResourceOperationHistory.findByGroupOperationHistoryId", query="select h from ResourceOperationHistory h where h.groupOperationHistory.id = :groupHistoryId "), @NamedQuery(name="ResourceOperationHistory.findByResourceIdAndStatus", query="select h from ResourceOperationHistory h where h.resource.id = :resourceId and h.status = :status"), @NamedQuery(name="ResourceOperationHistory.findByResourceIdAndNotStatus", query="SELECT h   FROM ResourceOperationHistory h  WHERE h.resource.id = :resourceId    AND h.status <> :status    AND (h.startedTime > :beginTime OR :beginTime IS NULL)    AND (h.modifiedTime < :endTime OR :endTime IS NULL) "), @NamedQuery(name="ResourceOperationHistory.findLatestCompletedOperation", query="select h from ResourceOperationHistory h where h.resource.id = :resourceId   and h.status <> 'INPROGRESS'   and h.modifiedTime = (select max(h2.modifiedTime) from ResourceOperationHistory h2 where h2.resource.id = :resourceId   and h2.status <> 'INPROGRESS')"), @NamedQuery(name="ResourceOperationHistory.findOldestInProgressOperation", query="select h from ResourceOperationHistory h where h.resource.id = :resourceId   and h.status = 'INPROGRESS'   and h.modifiedTime = (select min(h2.modifiedTime) from ResourceOperationHistory h2 where h2.resource.id = :resourceId   and h2.status = 'INPROGRESS')"), @NamedQuery(name="ResourceOperationHistory.deleteByResources", query="DELETE FROM ResourceOperationHistory roh  WHERE roh.resource.id IN ( :resourceIds ) )"), @NamedQuery(name="OperationHistory.findAll_admin", query="   SELECT new org.rhq.core.domain.operation.composite.ResourceOperationHistoryComposite        ( roh, parent.id, parent.name )      FROM ResourceOperationHistory roh      JOIN roh.resource res LEFT JOIN res.parentResource parent     WHERE (UPPER(res.name) LIKE :resourceFilter ESCAPE :escapeChar OR :resourceFilter IS NULL)       AND (UPPER(parent.name) LIKE :parentFilter ESCAPE :escapeChar OR :parentFilter IS NULL)       AND (roh.startedTime > :startTime OR :startTime IS NULL)       AND (roh.modifiedTime < :endTime OR :endTime IS NULL)       AND (roh.status LIKE :status OR :status IS NULL) "), @NamedQuery(name="OperationHistory.findAll", query="   SELECT new org.rhq.core.domain.operation.composite.ResourceOperationHistoryComposite        ( roh, parent.id, parent.name )      FROM ResourceOperationHistory roh      JOIN roh.resource res LEFT JOIN res.parentResource parent     WHERE res.id IN ( SELECT rr.id FROM Resource rr                         JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s                        WHERE s.id = :subjectId )       AND (UPPER(res.name) LIKE :resourceFilter ESCAPE :escapeChar OR :resourceFilter IS NULL)       AND (UPPER(parent.name) LIKE :parentFilter ESCAPE :escapeChar OR :parentFilter IS NULL)       AND (roh.startedTime > :startTime OR :startTime IS NULL)       AND (roh.modifiedTime < :endTime OR :endTime IS NULL)       AND (roh.status LIKE :status OR :status IS NULL) ")})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResourceOperationHistory
extends OperationHistory {
    public static final String QUERY_FIND_ALL_IN_STATUS = "ResourceOperationHistory.findAllInStatus";
    public static final String QUERY_FIND_BY_GROUP_OPERATION_HISTORY_ID = "ResourceOperationHistory.findByGroupOperationHistoryId";
    public static final String QUERY_FIND_BY_RESOURCE_ID_AND_STATUS = "ResourceOperationHistory.findByResourceIdAndStatus";
    public static final String QUERY_FIND_BY_RESOURCE_ID_AND_NOT_STATUS = "ResourceOperationHistory.findByResourceIdAndNotStatus";
    public static final String QUERY_FIND_LATEST_COMPLETED_OPERATION = "ResourceOperationHistory.findLatestCompletedOperation";
    public static final String QUERY_FIND_OLDEST_INPROGRESS_OPERATION = "ResourceOperationHistory.findOldestInProgressOperation";
    public static final String QUERY_DELETE_BY_RESOURCES = "ResourceOperationHistory.deleteByResources";
    public static final String QUERY_FIND_ALL = "OperationHistory.findAll";
    public static final String QUERY_FIND_ALL_ADMIN = "OperationHistory.findAll_admin";
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="RESOURCE_ID", referencedColumnName="ID")
    @ManyToOne
    @XmlTransient
    private Resource resource;
    @JoinColumn(name="RESULTS_CONFIG_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Configuration results;
    @JoinColumn(name="GROUP_HISTORY_ID", referencedColumnName="ID")
    @ManyToOne
    private GroupOperationHistory groupOperationHistory;

    protected ResourceOperationHistory() {
    }

    public ResourceOperationHistory(String jobName, String jobGroup, String subjectName, OperationDefinition operationDefinition, Configuration parameters, Resource resource, GroupOperationHistory groupHistory) {
        super(jobName, jobGroup, subjectName, operationDefinition, parameters);
        this.resource = resource;
        this.setGroupOperationHistory(groupHistory);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Configuration getResults() {
        return this.results;
    }

    public void setResults(Configuration results) {
        this.results = results;
    }

    public GroupOperationHistory getGroupOperationHistory() {
        return this.groupOperationHistory;
    }

    public void setGroupOperationHistory(GroupOperationHistory groupOperationHistory) {
        this.groupOperationHistory = groupOperationHistory;
        if (this.groupOperationHistory != null) {
            groupOperationHistory.addResourceOperationHistory(this);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ResourceOperationHistory: ");
        str.append("resource=[" + this.resource);
        if (Boolean.getBoolean("rhq.test.operation.show-values")) {
            str.append("], results=[" + this.results);
        }
        str.append("], group-history=[" + this.groupOperationHistory);
        str.append("], " + super.toString());
        str.append("]");
        return str.toString();
    }
}

