/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.plugin;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.rhq.core.domain.plugin.AbstractPlugin;
import org.rhq.core.domain.plugin.PluginDeploymentType;
import org.rhq.core.domain.plugin.PluginStatusType;

@DiscriminatorValue(value="AGENT")
@NamedQueries(value={@NamedQuery(name="Plugin.updatePluginEnabledById", query="UPDATE Plugin p    SET p.enabled = :enabled  WHERE p.id = :id)"), @NamedQuery(name="Plugin.queryGetStatusByName", query=" SELECT p.status    FROM Plugin AS p   WHERE p.name = :name)"), @NamedQuery(name="Plugin.queryGetNamesByEnabled", query=" SELECT p.name    FROM Plugin AS p   WHERE p.enabled = :enabled         AND p.status = 'INSTALLED' "), @NamedQuery(name="Plugin.findByIds", query=" SELECT new org.rhq.core.domain.plugin.Plugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.ctime,         p.mtime)    FROM Plugin AS p   WHERE p.id IN (:ids)         AND p.status = 'INSTALLED' "), @NamedQuery(name="Plugin.findAllByIds", query=" SELECT new org.rhq.core.domain.plugin.Plugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.ctime,         p.mtime)    FROM Plugin AS p   WHERE p.id IN (:ids) "), @NamedQuery(name="Plugin.findByName", query=" SELECT new org.rhq.core.domain.plugin.Plugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.ctime,         p.mtime)    FROM Plugin AS p   WHERE p.name=:name         AND p.status = 'INSTALLED' "), @NamedQuery(name="Plugin.findAnyByName", query=" SELECT new org.rhq.core.domain.plugin.Plugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.ctime,         p.mtime)    FROM Plugin AS p   WHERE p.name=:name "), @NamedQuery(name="Plugin.findAllInstalled", query=" SELECT new org.rhq.core.domain.plugin.Plugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.ctime,         p.mtime)    FROM Plugin AS p    WHERE p.status = 'INSTALLED' "), @NamedQuery(name="Plugin.updatePluginsEnabledByIds", query="UPDATE Plugin p    SET p.enabled = :enabled  WHERE p.id IN (:ids)"), @NamedQuery(name="Plugin.findByResourceType", query="  SELECT new org.rhq.core.domain.plugin.Plugin(          p.id,          p.name,          p.path,          p.displayName,          p.enabled,          p.status,          p.description,          p.help,          p.md5,          p.version,          p.ampsVersion,          p.ctime,          p.mtime)     FROM Plugin p    WHERE p.status = 'INSTALLED' AND          p.name IN ( SELECT rt.plugin                        FROM Resource res                        JOIN res.resourceType rt                       WHERE ( rt.category = :resourceCategory OR :resourceCategory IS NULL )                         AND ( rt.name = :resourceTypeName OR :resourceTypeName IS NULL ) )  ORDER BY p.name")})
@Entity
public class Plugin
extends AbstractPlugin {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_GET_STATUS_BY_NAME = "Plugin.queryGetStatusByName";
    public static final String QUERY_GET_NAMES_BY_ENABLED = "Plugin.queryGetNamesByEnabled";
    public static final String QUERY_FIND_BY_IDS = "Plugin.findByIds";
    public static final String QUERY_FIND_ALL_BY_IDS = "Plugin.findAllByIds";
    public static final String QUERY_FIND_BY_NAME = "Plugin.findByName";
    public static final String QUERY_FIND_ANY_BY_NAME = "Plugin.findAnyByName";
    public static final String QUERY_FIND_ALL_INSTALLED = "Plugin.findAllInstalled";
    public static final String UPDATE_PLUGINS_ENABLED_BY_IDS = "Plugin.updatePluginsEnabledByIds";
    public static final String QUERY_FIND_BY_RESOURCE_TYPE_AND_CATEGORY = "Plugin.findByResourceType";
    public static final String UPDATE_PLUGIN_ENABLED_BY_ID = "Plugin.updatePluginEnabledById";

    public Plugin() {
        this.setDeployment(PluginDeploymentType.AGENT);
    }

    public Plugin(String name, String path) {
        super(name, path);
        this.setDeployment(PluginDeploymentType.AGENT);
    }

    public Plugin(String name, String path, String md5) {
        super(name, path, md5);
        this.setDeployment(PluginDeploymentType.AGENT);
    }

    public Plugin(String name, String path, byte[] content) {
        super(name, path, content);
        this.setDeployment(PluginDeploymentType.AGENT);
    }

    public Plugin(int id, String name, String path, String displayName, boolean enabled, PluginStatusType status, String description, String help, String md5, String version, String ampsVersion, long ctime, long mtime) {
        super(id, name, path, displayName, enabled, status, description, help, md5, version, ampsVersion, PluginDeploymentType.AGENT, ctime, mtime);
    }

    public void setDeployment(PluginDeploymentType deployment) {
        if (deployment != PluginDeploymentType.AGENT) {
            throw new IllegalArgumentException("Plugin can only ever have deployment type of AGENT: " + (Object)((Object)deployment));
        }
        super.setDeployment(deployment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Plugin)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "AgentPlugin " + super.toString();
    }
}

