/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.plugin;

import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.plugin.PluginDeploymentType;
import org.rhq.core.domain.plugin.ServerPlugin;

public class PluginKey {
    private final PluginDeploymentType deployment;
    private final String pluginType;
    private final String pluginName;

    public static PluginKey createAgentPluginKey(String pluginName) {
        return new PluginKey(PluginDeploymentType.AGENT, null, pluginName);
    }

    public static PluginKey createServerPluginKey(String pluginType, String pluginName) {
        if (pluginType == null || pluginType.length() == 0) {
            throw new IllegalArgumentException("invalid pluginType: " + pluginType);
        }
        return new PluginKey(PluginDeploymentType.SERVER, pluginType, pluginName);
    }

    public PluginKey(Plugin plugin) {
        this(plugin.getDeployment(), null, plugin.getName());
    }

    public PluginKey(ServerPlugin plugin) {
        this(plugin.getDeployment(), plugin.getType(), plugin.getName());
    }

    public PluginKey(PluginDeploymentType deployment, String pluginType, String pluginName) {
        if (deployment == null) {
            throw new IllegalArgumentException("deployment==null");
        }
        if (pluginType == null && deployment != PluginDeploymentType.AGENT) {
            throw new IllegalArgumentException("only agent plugins can have null type");
        }
        if (pluginType != null && deployment == PluginDeploymentType.AGENT) {
            throw new IllegalArgumentException("agent plugins must have null type");
        }
        if (pluginName == null || pluginName.length() == 0) {
            throw new IllegalArgumentException("invalid pluginName: " + pluginName);
        }
        this.deployment = deployment;
        this.pluginType = pluginType;
        this.pluginName = pluginName;
    }

    public PluginDeploymentType getDeployment() {
        return this.deployment;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PluginKey [deployment=").append((Object)this.deployment).append(", pluginType=").append(this.pluginType).append(", pluginName=").append(this.pluginName).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.deployment.hashCode();
        result = 31 * result + (this.pluginType == null ? 0 : this.pluginType.hashCode());
        result = 31 * result + this.pluginName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PluginKey)) {
            return false;
        }
        PluginKey other = (PluginKey)obj;
        if (!this.pluginName.equals(other.pluginName)) {
            return false;
        }
        if (this.pluginType == null ? other.pluginType != null : !this.pluginType.equals(other.pluginType)) {
            return false;
        }
        return this.deployment == other.deployment;
    }
}

