/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

@Entity(name="CreateResourceHistory")
@NamedQueries(value={@NamedQuery(name="CreateResourceHistory.findWithStatus", query="SELECT crh FROM CreateResourceHistory AS crh WHERE crh.status = :status"), @NamedQuery(name="CreateResourceHistory.findByParentResourceId", query="SELECT crh   FROM CreateResourceHistory AS crh  WHERE crh.parentResource.id = :id   AND ( crh.ctime > :startTime OR :startTime IS NULL )    AND ( crh.mtime < :endTime OR :endTime IS NULL ) "), @NamedQuery(name="CreateResourceHistory.findById", query="SELECT crh FROM CreateResourceHistory AS crh WHERE crh.id = :id"), @NamedQuery(name="CreateResourceHistory.deleteByResources", query="DELETE FROM CreateResourceHistory crh WHERE crh.parentResource.id IN ( :resourceIds ) )")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CREATE_RES_HIST_ID_SEQ")
@Table(name="RHQ_CREATE_RES_HIST")
public class CreateResourceHistory
implements Serializable {
    public static final String QUERY_FIND_WITH_STATUS = "CreateResourceHistory.findWithStatus";
    public static final String QUERY_FIND_BY_PARENT_RESOURCE_ID = "CreateResourceHistory.findByParentResourceId";
    public static final String QUERY_FIND_BY_ID = "CreateResourceHistory.findById";
    public static final String QUERY_DELETE_BY_RESOURCES = "CreateResourceHistory.deleteByResources";
    @GeneratedValue(generator="SEQ", strategy=GenerationType.AUTO)
    @Id
    private int id;
    @Column(name="ERROR_MESSAGE")
    private String errorMessage;
    @Column(name="SUBJECT_NAME", nullable=false)
    private String subjectName;
    @Column(name="CTIME", nullable=false)
    private long ctime = System.currentTimeMillis();
    @Column(name="MTIME", nullable=false)
    private long mtime = System.currentTimeMillis();
    @JoinColumn(name="PARENT_RESOURCE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private Resource parentResource;
    @Column(name="CREATED_RESOURCE_NAME", nullable=true)
    private String createdResourceName;
    @Column(name="NEW_RESOURCE_KEY")
    private String newResourceKey;
    @Column(name="STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private CreateResourceStatus status;
    @JoinColumn(name="RESOURCE_TYPE_ID", referencedColumnName="ID")
    @OneToOne(fetch=FetchType.EAGER)
    private ResourceType resourceType;
    @JoinColumn(name="CONFIGURATION_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.ALL})
    private Configuration configuration;
    @JoinColumn(name="INSTALLED_PACKAGE_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.PERSIST})
    private InstalledPackage installedPackage;

    public CreateResourceHistory() {
    }

    public CreateResourceHistory(Resource parentResource, ResourceType resourceType, String subjectName, Configuration resourceConfiguration) {
        this.parentResource = parentResource;
        this.subjectName = subjectName;
        this.resourceType = resourceType;
        this.configuration = resourceConfiguration;
    }

    public CreateResourceHistory(Resource parentResource, ResourceType resourceType, String subjectName, InstalledPackage installedPackage) {
        this.parentResource = parentResource;
        this.subjectName = subjectName;
        this.resourceType = resourceType;
        this.installedPackage = installedPackage;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Resource getParentResource() {
        return this.parentResource;
    }

    public void setParentResource(Resource parentResource) {
        this.parentResource = parentResource;
    }

    public String getCreatedResourceName() {
        return this.createdResourceName;
    }

    public void setCreatedResourceName(String createdResourceName) {
        this.createdResourceName = createdResourceName;
    }

    public String getNewResourceKey() {
        return this.newResourceKey;
    }

    public void setNewResourceKey(String newResourceKey) {
        this.newResourceKey = newResourceKey;
    }

    public CreateResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(CreateResourceStatus status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (errorMessage != null) {
            this.setStatus(CreateResourceStatus.FAILURE);
        }
    }

    public void setErrorMessageFromThrowable(Throwable t) {
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            this.setErrorMessage(baos.toString());
        } else {
            this.setErrorMessage(null);
        }
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public long getCreatedTime() {
        return this.ctime;
    }

    public Date getCreatedDate() {
        return new Date(this.ctime);
    }

    public long getLastModifiedTime() {
        return this.mtime;
    }

    public Date getLastModifiedDate() {
        return new Date(this.mtime);
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public InstalledPackage getInstalledPackage() {
        return this.installedPackage;
    }

    public void setInstalledPackage(InstalledPackage installedPackage) {
        this.installedPackage = installedPackage;
    }

    public long getDuration() {
        long start = this.ctime;
        long end = this.mtime;
        if (this.status == null || this.status == CreateResourceStatus.IN_PROGRESS) {
            end = System.currentTimeMillis();
        }
        return end - start;
    }

    @PrePersist
    void onPersist() {
        this.mtime = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.mtime = System.currentTimeMillis();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.ctime ^ this.ctime >>> 32);
        result = 31 * result + (this.subjectName == null ? 0 : this.subjectName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CreateResourceHistory)) {
            return false;
        }
        CreateResourceHistory other = (CreateResourceHistory)obj;
        if (this.ctime != other.ctime) {
            return false;
        }
        return !(this.subjectName == null ? other.subjectName != null : !this.subjectName.equals(other.subjectName));
    }
}

