/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.serial.ExternalizableStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySerializer {
    private static Set<Class<? extends Annotation>> PERSISTENCE_ANNOTATIONS = new HashSet<Class<? extends Annotation>>();
    private static Set<Class<?>> BASIC_TYPES;
    private static Comparator<Field> fieldComparator;

    private static Field[] getFields(Object object) {
        Class<?> objectClass = object.getClass();
        Entity entityAnnotation = objectClass.getAnnotation(Entity.class);
        List<Field> serializableFields = entityAnnotation == null ? EntitySerializer.getNonEntityFieldList(object) : EntitySerializer.getEntityFieldList(object);
        Collections.sort(serializableFields, fieldComparator);
        Field[] results = serializableFields.toArray(new Field[serializableFields.size()]);
        return results;
    }

    private static List<Field> getNonEntityFieldList(Object object) {
        Class<?> objectClass = object.getClass();
        Field[] fields = objectClass.getDeclaredFields();
        ArrayList<Field> serializableFields = new ArrayList<Field>();
        for (Field field : fields) {
            serializableFields.add(field);
            field.setAccessible(true);
        }
        return serializableFields;
    }

    private static List<Field> getEntityFieldList(Object entity) {
        Class<?> entityClass = entity.getClass();
        Entity entityAnnotation = entityClass.getAnnotation(Entity.class);
        if (entityAnnotation == null) {
            throw new IllegalArgumentException("EntitySerializer only introspects objects annotated with @Entity ");
        }
        ArrayList<Field> serializableFields = new ArrayList<Field>();
        while (entityClass != null) {
            Field[] fields;
            block1: for (Field field : fields = entityClass.getDeclaredFields()) {
                Annotation[] fieldAnnotations;
                for (Annotation fieldAnnotation : fieldAnnotations = field.getAnnotations()) {
                    if (!PERSISTENCE_ANNOTATIONS.contains(fieldAnnotation.annotationType())) continue;
                    serializableFields.add(field);
                    field.setAccessible(true);
                    continue block1;
                }
            }
            entityClass = entityClass.getSuperclass();
        }
        return serializableFields;
    }

    public static void writeExternalRemote(Object object, ObjectOutput out) throws IOException {
        Field[] fields;
        for (Field field : fields = EntitySerializer.getFields(object)) {
            try {
                Class<?> type = field.getType();
                Object value = field.get(object);
                if (BASIC_TYPES.contains(type)) {
                    if (type.equals(Byte.TYPE)) {
                        out.writeByte(((Byte)value).byteValue());
                        continue;
                    }
                    if (type.equals(Short.TYPE)) {
                        out.writeShort(((Short)value).shortValue());
                        continue;
                    }
                    if (type.equals(Integer.TYPE)) {
                        out.writeInt((Integer)value);
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        out.writeLong((Long)value);
                        continue;
                    }
                    if (type.equals(Float.TYPE)) {
                        out.writeFloat(((Float)value).floatValue());
                        continue;
                    }
                    if (type.equals(Double.TYPE)) {
                        out.writeDouble((Double)value);
                        continue;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        out.writeBoolean((Boolean)value);
                        continue;
                    }
                    throw new IllegalStateException("BASIC_TYPES contains an entry that doesn't have serialization support: " + type);
                }
                out.writeObject(value);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException("Could not access field '" + field.getName() + "' for serialization");
            }
        }
    }

    public static void readExternalRemote(Object object, ObjectInput in) throws IOException, ClassNotFoundException {
        Field[] fields;
        for (Field field : fields = EntitySerializer.getFields(object)) {
            try {
                Class<?> type = field.getType();
                if (BASIC_TYPES.contains(type)) {
                    if (type.equals(Byte.TYPE)) {
                        field.setByte(object, in.readByte());
                        continue;
                    }
                    if (type.equals(Short.TYPE)) {
                        field.setShort(object, in.readShort());
                        continue;
                    }
                    if (type.equals(Integer.TYPE)) {
                        field.setInt(object, in.readInt());
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        field.setLong(object, in.readLong());
                        continue;
                    }
                    if (type.equals(Float.TYPE)) {
                        field.setFloat(object, in.readFloat());
                        continue;
                    }
                    if (type.equals(Double.TYPE)) {
                        field.setDouble(object, in.readDouble());
                        continue;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        field.setBoolean(object, in.readBoolean());
                        continue;
                    }
                    throw new IllegalStateException("BASIC_TYPES contains an entry that doesn't have deserialization support: " + type);
                }
                field.set(object, in.readObject());
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException("Could not access field '" + field.getName() + "' for deserialization");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ExternalizableStrategy.setStrategy(ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION);
        Agent writeAgent = new Agent("reflectiveAgent", "reflectiveAddress", 0, "reflectiveEndpoint", "reflectiveToken");
        ResourceType writeResourceType = new ResourceType();
        writeResourceType.setName("reflectiveType");
        writeResourceType.setPlugin("reflectivePlugin");
        writeResourceType.setId(7);
        Resource writeParentResource = new Resource();
        writeParentResource.setId(11);
        writeParentResource.setName("reflectiveParentResource");
        writeParentResource.setResourceKey("reflectiveParentKey");
        Resource writeResource = new Resource();
        writeResource.setId(42);
        writeResource.setName("reflectiveResource");
        writeResource.setResourceKey("reflectiveKey");
        writeResource.setAgent(writeAgent);
        writeResource.setResourceType(writeResourceType);
        writeResource.setParentResource(writeParentResource);
        System.out.println("BEFORE");
        System.out.println(writeResource.toString());
        System.out.println("BEFORE");
        String tempDir = System.getProperty("java.io.tmpdir");
        File tempFile = new File(tempDir, "entitySerializerTest.txt");
        ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(tempFile));
        EntitySerializer.writeExternalRemote(writeResource, output);
        output.close();
        Resource readResource = new Resource();
        ObjectInputStream input = new ObjectInputStream(new FileInputStream(tempFile));
        EntitySerializer.readExternalRemote(readResource, input);
        input.close();
        System.out.println("AFTER");
        System.out.println(readResource.toString());
        System.out.println("AFTER");
        boolean equalsResource = writeResource.equals(readResource);
        boolean equalsParentResource = writeParentResource.equals(readResource.getParentResource());
        boolean equalsResourceType = writeResourceType.equals(readResource.getResourceType());
        boolean equalsAgent = writeAgent.equals(readResource.getAgent());
        System.out.println("equalsResource: " + equalsResource);
        System.out.println("equalsParentResource: " + equalsParentResource);
        System.out.println("equalsResourceType: " + equalsResourceType);
        System.out.println("equalsAgent: " + equalsAgent);
    }

    static {
        PERSISTENCE_ANNOTATIONS.add(Id.class);
        PERSISTENCE_ANNOTATIONS.add(Column.class);
        PERSISTENCE_ANNOTATIONS.add(ManyToOne.class);
        PERSISTENCE_ANNOTATIONS.add(OneToMany.class);
        PERSISTENCE_ANNOTATIONS.add(ManyToMany.class);
        BASIC_TYPES = new HashSet();
        BASIC_TYPES.add(Byte.TYPE);
        BASIC_TYPES.add(Short.TYPE);
        BASIC_TYPES.add(Integer.TYPE);
        BASIC_TYPES.add(Long.TYPE);
        BASIC_TYPES.add(Float.TYPE);
        BASIC_TYPES.add(Double.TYPE);
        BASIC_TYPES.add(Boolean.TYPE);
        fieldComparator = new Comparator<Field>(){

            @Override
            public int compare(Field first, Field second) {
                return first.getName().compareTo(second.getName());
            }
        };
    }
}

