/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.util.serial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateUtil {
    public static <T> List<T> safeList(List<T> list) {
        if (null == list) {
            return null;
        }
        return list.getClass().getName().contains("hibernate") ? new ArrayList(list) : list;
    }

    public static <T> Set<T> safeSet(Set<T> set) {
        if (null == set) {
            return null;
        }
        return set.getClass().getName().contains("hibernate") ? new LinkedHashSet(set) : set;
    }

    public static <T> Collection<T> safeCollection(Collection<T> collection) {
        if (null == collection) {
            return null;
        }
        return collection.getClass().getName().contains("hibernate") ? new LinkedHashSet(collection) : collection;
    }

    public static <K, V> Map<K, V> safeMap(Map<K, V> map) {
        if (null == map) {
            return null;
        }
        return map.getClass().getName().contains("hibernate") ? new LinkedHashMap(map) : map;
    }
}

