/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.shared;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.shared.BuilderException;
import org.rhq.core.domain.shared.ResourceTypeBuilder;

public class ResourceBuilder {
    private ResourceBuilder parentBuilder;
    private Resource resource;
    private Random random;
    private boolean useDefaultResourceType;
    private ResourceCategory category;
    private List<ResourceBuilder> childBuilders = new ArrayList<ResourceBuilder>();

    public ResourceBuilder() {
    }

    private ResourceBuilder(ResourceCategory category, ResourceBuilder parentBuilder) {
        this.category = category;
        this.parentBuilder = parentBuilder;
    }

    public ResourceBuilder createResource() {
        this.resource = new Resource();
        this.random = new Random();
        return this;
    }

    public ResourceBuilder createPlatform() {
        this.category = ResourceCategory.PLATFORM;
        return this.createResource();
    }

    public ResourceBuilder createServer() {
        this.category = ResourceCategory.SERVER;
        return this.createResource();
    }

    public ResourceBuilder createRandomServer() {
        this.category = ResourceCategory.SERVER;
        this.createResource();
        this.withRandomId();
        this.withRandomName("server:");
        this.withRandomResourceKey("server:");
        this.withRandomUuid("server:");
        this.withDefaultServerResourceType();
        return this;
    }

    public ResourceBuilder createService() {
        this.category = ResourceCategory.SERVICE;
        return this.createResource();
    }

    public ResourceBuilder createRandomService() {
        this.category = ResourceCategory.SERVICE;
        this.createResource();
        this.withRandomId();
        this.withRandomName("service:");
        this.withRandomResourceKey("service:");
        this.withRandomUuid("service:");
        this.withDefaultServiceResourceType();
        return this;
    }

    public ResourceBuilder usingDefaultResourceType() {
        this.useDefaultResourceType = true;
        return this;
    }

    public ResourceBuilder withId(int id) {
        this.resource.setId(id);
        return this;
    }

    public ResourceBuilder withRandomId() {
        this.resource.setId(this.random.nextInt());
        return this;
    }

    public ResourceBuilder withResourceKey(String key) {
        this.resource.setResourceKey(key);
        return this;
    }

    public ResourceBuilder withRandomResourceKey(String prefix) {
        this.resource.setResourceKey(prefix + this.randomString());
        return this;
    }

    public ResourceBuilder withRandomResourceKey() {
        return this.withRandomResourceKey("");
    }

    public ResourceBuilder withName(String name) {
        this.resource.setName(name);
        return this;
    }

    public ResourceBuilder withRandomName(String prefix) {
        this.resource.setName(prefix + this.randomString());
        return this;
    }

    public ResourceBuilder withRandomName() {
        return this.withRandomName("");
    }

    public ResourceBuilder withResourceType(ResourceType resourceType) {
        this.resource.setResourceType(resourceType);
        return this;
    }

    public ResourceBuilder withUuid(String uuid) {
        this.resource.setUuid(uuid);
        return this;
    }

    public ResourceBuilder withRandomUuid(String prefix) {
        this.resource.setUuid(prefix + this.randomString());
        return this;
    }

    public ResourceBuilder withRandomUuid() {
        return this.withRandomUuid("");
    }

    public ResourceBuilder withVersion(String version) {
        this.resource.setVersion(version);
        return this;
    }

    public ResourceBuilder withCurrentAvailability(AvailabilityType availabilityType) {
        ResourceAvailability availability = new ResourceAvailability(this.resource, availabilityType);
        this.resource.setCurrentAvailability(availability);
        return this;
    }

    public ResourceBuilder withInventoryStatus(InventoryStatus inventoryStatus) {
        this.resource.setInventoryStatus(inventoryStatus);
        return this;
    }

    public ResourceBuilder inInventory() {
        this.resource.setInventoryStatus(InventoryStatus.COMMITTED);
        return this;
    }

    public ResourceBuilder notInInventory() {
        this.resource.setInventoryStatus(InventoryStatus.NEW);
        return this;
    }

    public AssociationBuilder with(int count) {
        return new AssociationBuilder(this, count);
    }

    public ResourceBuilder withChildService() {
        ResourceBuilder childBuilder = new ResourceBuilder(ResourceCategory.SERVICE, this);
        this.childBuilders.add(childBuilder.createService());
        return childBuilder;
    }

    public ResourceBuilder included() {
        return this.parentBuilder;
    }

    public Resource build() {
        String errors = this.validate();
        if (errors != null) {
            throw new BuilderException(errors);
        }
        if (this.useDefaultResourceType) {
            this.withDefaultResourceType();
        }
        for (ResourceBuilder childBuilder : this.childBuilders) {
            this.resource.addChildResource(childBuilder.build());
        }
        return this.resource;
    }

    private String validate() {
        StringBuilder errors = new StringBuilder();
        if (this.resource.getUuid() == null) {
            errors.append("uuid is a required property\n");
        }
        if (this.resource.getName() == null) {
            errors.append("name is a required property\n");
        }
        if (this.useDefaultResourceType && this.category == null) {
            errors.append("When using default resource type, the resource must be created with one of createPlatform(), createServer(), or createService()\n");
        }
        if (!this.useDefaultResourceType && this.resource.getResourceType() == null) {
            errors.append("resourceType is a required property\n");
        }
        for (ResourceBuilder childBuilder : this.childBuilders) {
            String childErrors = childBuilder.validate();
            if (childErrors == null) continue;
            errors.append("The following child resource errors were found:\n" + childErrors);
        }
        if (errors.length() == 0) {
            return null;
        }
        return "Unable to build Resource instance due to the following validation errors:\n" + errors;
    }

    private ResourceBuilder withDefaultResourceType() {
        switch (this.category) {
            case PLATFORM: {
                return this.withDefaultPlatformResourceType();
            }
            case SERVER: {
                return this.withDefaultServerResourceType();
            }
        }
        return this.withDefaultServiceResourceType();
    }

    private ResourceBuilder withDefaultPlatformResourceType() {
        this.resource.setResourceType(new ResourceTypeBuilder().createPlatformResourceType().withName(this.resource.getName()).withPlugin(this.resource.getName() + " Plugin").withParentResourceType(this.resource.getResourceType()).build());
        return this;
    }

    private ResourceBuilder withDefaultServerResourceType() {
        this.resource.setResourceType(new ResourceTypeBuilder().createServerResourceType().withName(this.resource.getName()).withPlugin(this.resource.getName() + " Plugin").withParentResourceType(this.resource.getResourceType()).build());
        return this;
    }

    private ResourceBuilder withDefaultServiceResourceType() {
        this.resource.setResourceType(new ResourceTypeBuilder().createServerResourceType().withName(this.resource.getName()).withPlugin(this.resource.getName() + " Plugin").withParentResourceType(this.resource.getResourceType()).build());
        return this;
    }

    private String randomString() {
        return new BigInteger(16, this.random).toString(32);
    }

    public static class ChildrenResourceBuilder {
        private ResourceBuilder parentBuilder;

        ChildrenResourceBuilder(ResourceBuilder builder, ResourceCategory category, int numChildren) {
            this.parentBuilder = builder;
            this.parentBuilder.childBuilders = new ArrayList(numChildren);
            for (int i = 0; i < numChildren; ++i) {
                this.parentBuilder.childBuilders.add(new ResourceBuilder(category, this.parentBuilder).createResource());
            }
        }

        public ChildrenResourceBuilder inInventory() {
            for (ResourceBuilder childBuilder : this.parentBuilder.childBuilders) {
                childBuilder.inInventory();
            }
            return this;
        }

        public ChildrenResourceBuilder notInInventory() {
            for (ResourceBuilder childBuilder : this.parentBuilder.childBuilders) {
                childBuilder.notInInventory();
            }
            return this;
        }

        public ResourceBuilder included() {
            return this.parentBuilder;
        }
    }

    public static class AssociationBuilder {
        private ResourceBuilder resourceBuilder;
        private int count;

        AssociationBuilder(ResourceBuilder builder, int count) {
            this.resourceBuilder = builder;
            this.count = count;
        }

        public ResourceBuilder randomChildServers() {
            for (int i = 0; i < this.count; ++i) {
                ResourceBuilder childBuilder = new ResourceBuilder(ResourceCategory.SERVER, this.resourceBuilder);
                this.resourceBuilder.childBuilders.add(childBuilder.createRandomServer());
            }
            return this.resourceBuilder;
        }

        public ResourceBuilder randomChildServices() {
            for (int i = 0; i < this.count; ++i) {
                ResourceBuilder childBuilder = new ResourceBuilder(ResourceCategory.SERVICE, this.resourceBuilder);
                this.resourceBuilder.childBuilders.add(childBuilder.createRandomService());
            }
            return this.resourceBuilder;
        }
    }
}

