/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.shared;

import java.util.HashSet;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.shared.BuilderException;

public class ResourceTypeBuilder {
    private ResourceType resourceType;

    public ResourceTypeBuilder createResourceType() {
        this.resourceType = new ResourceType();
        this.resourceType.setParentResourceTypes(new HashSet());
        this.resourceType.setChildResourceTypes(new HashSet());
        return this;
    }

    public ResourceTypeBuilder createPlatformResourceType() {
        return this.createResourceType().withCategory(ResourceCategory.PLATFORM);
    }

    public ResourceTypeBuilder createServerResourceType() {
        return this.createResourceType().withCategory(ResourceCategory.SERVER);
    }

    public ResourceTypeBuilder createServiceResourceType() {
        return this.createResourceType().withCategory(ResourceCategory.SERVICE);
    }

    public ResourceTypeBuilder withId(int id) {
        this.resourceType.setId(id);
        return this;
    }

    public ResourceTypeBuilder withName(String name) {
        this.resourceType.setName(name);
        return this;
    }

    public ResourceTypeBuilder withPlugin(String plugin) {
        this.resourceType.setPlugin(plugin);
        return this;
    }

    public ResourceTypeBuilder withCategory(ResourceCategory category) {
        this.resourceType.setCategory(category);
        return this;
    }

    public ResourceTypeBuilder thatIsDeleted() {
        this.resourceType.setDeleted(true);
        return this;
    }

    public ResourceTypeBuilder thatIsNotDeleted() {
        this.resourceType.setDeleted(false);
        return this;
    }

    public ResourceTypeBuilder withParentResourceType(ResourceType parentResourceType) {
        if (parentResourceType != null) {
            this.resourceType.addParentResourceType(parentResourceType);
        }
        return this;
    }

    public ResourceTypeBuilder withParentResourceTypes(ResourceType ... parentResourceTypes) {
        for (ResourceType parent : parentResourceTypes) {
            this.resourceType.addParentResourceType(parent);
        }
        return this;
    }

    public ResourceType build() {
        String errors = this.valdiate();
        if (errors != null) {
            throw new BuilderException(errors);
        }
        return this.resourceType;
    }

    private String valdiate() {
        StringBuilder errors = new StringBuilder();
        if (this.resourceType.getName() == null) {
            errors.append("name is a required property\n");
        }
        if (this.resourceType.getCategory() == null) {
            errors.append("category is a required property\n");
        }
        if (this.resourceType.getCreationDataType() == null) {
            errors.append("creationDate is a required property\n");
        }
        if (this.resourceType.getCreateDeletePolicy() == null) {
            errors.append("createDeletePolicy is a required property\n");
        }
        if (this.resourceType.getPlugin() == null) {
            errors.append("plugin is a required property\n");
        }
        if (errors.length() == 0) {
            return null;
        }
        return "Unable to build ResourceType instance due to the following validation errors:\n" + errors;
    }
}

