/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration;

import java.util.Collection;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.gui.configuration.AbstractConfigurationComponent;
import org.rhq.core.gui.configuration.AbstractPropertyBagUIComponentTreeFactory;
import org.rhq.core.gui.util.FacesExpressionUtility;

public class MapInListUIComponentTreeFactory
extends AbstractPropertyBagUIComponentTreeFactory {
    private Integer listIndex;

    public MapInListUIComponentTreeFactory(AbstractConfigurationComponent config, String listName, int listIndex) {
        super(config, MapInListUIComponentTreeFactory.getPropertyDefinitions(config.getConfigurationDefinition(), listName), (AbstractPropertyMap)((PropertyMap)config.getConfiguration().getList(listName).getList().get(listIndex)), true, MapInListUIComponentTreeFactory.createValueExpressionFormat(config.getConfigurationExpressionString(), listName, listIndex));
        this.listIndex = listIndex;
    }

    @Override
    protected Integer getListIndex() {
        return this.listIndex;
    }

    private static String createValueExpressionFormat(String configurationExpressionString, String listName, int listIndex) {
        StringBuilder expression = new StringBuilder();
        expression.append("#{");
        expression.append(FacesExpressionUtility.unwrapExpressionString(configurationExpressionString));
        expression.append(".");
        expression.append("map");
        expression.append("['").append(listName).append("'].");
        expression.append("list");
        expression.append("[").append(listIndex).append("].");
        expression.append("map");
        expression.append("['%s'].");
        expression.append("stringValue");
        expression.append("}");
        return expression.toString();
    }

    private static Collection<PropertyDefinition> getPropertyDefinitions(ConfigurationDefinition configurationDefinition, String listName) {
        PropertyDefinitionMap mapDefinition = (PropertyDefinitionMap)configurationDefinition.getPropertyDefinitionList(listName).getMemberDefinition();
        return mapDefinition.getPropertyDefinitions().values();
    }
}

