/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration.helper;

import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;

public class ConfigurationUtility {
    public static PropertyDefinition getPropertyDefinitionForProperty(Property property, ConfigurationDefinition configurationDefinition) {
        LinkedList<Property> propertyHierarchy = ConfigurationUtility.getPropertyHierarchy(property);
        Property topLevelProperty = propertyHierarchy.get(0);
        PropertyDefinition propertyDefinition = (PropertyDefinition)configurationDefinition.getPropertyDefinitions().get(topLevelProperty.getName());
        for (int i = 1; i < propertyHierarchy.size(); ++i) {
            Property subProperty = propertyHierarchy.get(i);
            if (propertyDefinition instanceof PropertyDefinitionMap) {
                propertyDefinition = ((PropertyDefinitionMap)propertyDefinition).get(subProperty.getName());
                continue;
            }
            if (!(propertyDefinition instanceof PropertyDefinitionList)) continue;
            propertyDefinition = ((PropertyDefinitionList)propertyDefinition).getMemberDefinition();
        }
        return propertyDefinition;
    }

    public static LinkedList<Property> getPropertyHierarchy(Property property) {
        LinkedList<Property> propertyHierarchy = new LinkedList<Property>();
        Property parentProperty = property;
        while ((parentProperty = ConfigurationUtility.getParentProperty(parentProperty)) != null) {
            propertyHierarchy.addFirst(parentProperty);
        }
        propertyHierarchy.add(property);
        return propertyHierarchy;
    }

    @Nullable
    public static Property getParentProperty(Property property) {
        Object parentProperty = property.getParentList() != null ? property.getParentList() : (property.getParentMap() != null ? property.getParentMap() : null);
        return parentProperty;
    }
}

